#include <sdktools>
#include <morecolors>

#pragma semicolon 1

#define PLUGIN_AUTHOR "Kerio / Dela"
#define PLUGIN_VERSION "1.0.1"

#define LOGO	"{green}[DiacrE]"

#define INTRO_SOUND "admin_plugin_diacre/bienvenue_remix.mp3"

#define	INTRO_DELAY	20.0
#define INTRO_DURATION 52.0
#define ROUND_DELAY 5.0

#define CONFIG_PATH "addons/sourcemod/configs/autoson.cfg"

Handle cvar_volume = INVALID_HANDLE;
Handle Timer1 = INVALID_HANDLE;
Handle Timer2 = INVALID_HANDLE;
Handle TimerSound = INVALID_HANDLE;

bool IsMuted[MAXPLAYERS + 1] = { false, ... };

bool IntroSoundPlayed = false;
bool BlockingSound = false;
bool PLUGIN_ACTIVE = true;

int RoundNumber = 0;

char ValidFormats[][] =
{
	"mdl", "phy", "vtx", "vvd",
	"vmt", "vtf", "png",
	"mp3", "wav"
};

ArrayList g_Sounds;
ArrayList g_Played;

public Plugin myinfo = 
{
	name = "[DiacrE] AutoSound System",
	author = PLUGIN_AUTHOR,
	description = "[DiacrE] AutoSound",
	version = PLUGIN_VERSION,
	url = "www.diacre.org"
};

public void OnPluginStart()
{
	LoadTranslations("diacre_autosound.phrases");
	
	HookEvent("round_start", OnRoundStart);
	HookEvent("round_end", OnRoundEnd);
	
	RegConsoleCmd("sm_stopall", Command_StopSound, "Activer/Désactiver les sons automatiques (commande client)");
	RegConsoleCmd("sm_stopmusic", Command_StopSound);
	
	RegAdminCmd("sm_autosound", Command_ToggleSound, ADMFLAG_GENERIC, "Activer/Désactiver les sons automatiques (commande serveur)");
	
	g_Sounds = new ArrayList(PLATFORM_MAX_PATH);
	g_Played = new ArrayList(PLATFORM_MAX_PATH);
	
	cvar_volume = CreateConVar("sm_diacre_autosound_volume", "0.6", "Volume des sons joués (Max 1.0)", FCVAR_PLUGIN, true, 0.1, true, 1.0);
	
	HookConVarChange(cvar_volume, action_VolumeChanged);
	
	AutoExecConfig(true, "diacre_autosound");
	
	LoadSoundList();
}

public void OnMapStart()
{
	IntroSoundPlayed = false;
	
	AddFolderToDownloadsTable("sound");
	
	PrecacheSound(INTRO_SOUND, true);
	
	RoundNumber = 0;
	
	char download[PLATFORM_MAX_PATH];
	
	for (int i = 0; i < g_Sounds.Length; i++)
	{
		char sPath[PLATFORM_MAX_PATH];
		g_Sounds.GetString(i, sPath, sizeof(sPath));
		PrecacheSound(sPath, true);

		Format(download, sizeof(download), "sound/%s", sPath);
		AddFileToDownloadsTable(download);
    }
}

public action_VolumeChanged(Handle convar, const char[] oldValue, const char[] newValue)
{
	if (convar != cvar_volume)
	{
		CPrintToChatAll("%s: %t", LOGO, "DIACRE_VolumeChanged", oldValue, newValue);
	}
}

public Action OnRoundStart(Handle event, char[] name, bool dontBroadcast)
{
	if (PLUGIN_ACTIVE)
	{
		if (!IntroSoundPlayed)
	    {
	    	IntroSoundPlayed = true;
	    	
	    	Timer1 = CreateTimer(INTRO_DELAY, Timer_SoundIntro);
	    }
	    
	    RoundNumber++;
	    
	    if (RoundNumber > 2)
	    {
	    	if (!BlockingSound)
	    	{
	   			TimerSound = CreateTimer(ROUND_DELAY, Timer_PlayRandomSound);
	   		}
	   	}
	}
	
	return Plugin_Continue;
}

public Action OnRoundEnd(Handle event, const char[] name, bool dontBroadcast)
{
	if (Timer1 != INVALID_HANDLE)
	{
		KillTimer(Timer1);
		Timer1 = INVALID_HANDLE;
	}
	
	if (Timer2 != INVALID_HANDLE)
	{
		KillTimer(Timer2);
		Timer2 = INVALID_HANDLE;
	}
	
	if (TimerSound != INVALID_HANDLE)
	{
		KillTimer(TimerSound);
		TimerSound = INVALID_HANDLE;
	}

	return Plugin_Continue;
}

public Action Timer_SoundIntro(Handle timer)
{
	if (PLUGIN_ACTIVE)
	{
		BlockingSound = true;
		
		for (int i = 1; i <= MaxClients; i++)
		{
			if (IsValid(i) && !IsMuted[i])
			{
				EmitSoundToClient(i, INTRO_SOUND, _, SNDCHAN_AUTO, _, _, GetConVarFloat(cvar_volume));
			}
		}
		
		Timer2 = CreateTimer(INTRO_DURATION, Timer_UnlockSounds);
	}
	
	Timer1 = INVALID_HANDLE;
	
	return Plugin_Stop;
}

public Action Timer_PlayRandomSound(Handle timer)
{
	if (PLUGIN_ACTIVE)
	{
		if (IntroSoundPlayed)
		{		
			if (g_Sounds.Length != 0)
			{
				int index = GetRandomSoundIndex();
				
				if (index == -1)
				{
				    g_Played.Clear();
				    index = GetRandomSoundIndex();
				    if (index == -1)
				        return Plugin_Stop;
				}
				
				char path[PLATFORM_MAX_PATH];
				g_Sounds.GetString(index, path, sizeof(path));
				
				for (int i = 1; i <= MaxClients; i++)
				{
					if (IsValid(i) && !IsMuted[i])
					{
						EmitSoundToClient(i, path, _, SNDCHAN_AUTO, _, _, GetConVarFloat(cvar_volume));
			    	}
			    }
				
				char name[PLATFORM_MAX_PATH];
				Format(name, sizeof(name), path[strlen("admin_plugin_diacre/")]);
				
				int dot = FindCharInString(name, '.', true);
					if (dot != -1)
				name[dot] = '\0';
				
				CPrintToChatAll("%s: {fullred}♫ {blue}%s {fullred}♫", LOGO, name);
				
				g_Played.PushString(path);
			}
		}
	}
	
	TimerSound = INVALID_HANDLE;
	
	return Plugin_Stop;
}

public Action Timer_UnlockSounds(Handle timer)
{
    BlockingSound = false;
    
    Timer2 = INVALID_HANDLE;
    
    return Plugin_Stop;
}

int GetRandomSoundIndex()
{
	ArrayList available = new ArrayList(PLATFORM_MAX_PATH);
	
	for (int i = 0; i < g_Sounds.Length; i++)
	{
		char candidate[PLATFORM_MAX_PATH];
		g_Sounds.GetString(i, candidate, sizeof(candidate));
	
		bool already = false;
		
		for (int j = 0; j < g_Played.Length; j++)
		{
			char played[PLATFORM_MAX_PATH];
			g_Played.GetString(j, played, sizeof(played));
	
			if (StrEqual(candidate, played))
			{
				already = true;
				break;
			}
		}
	
	    if (!already)
	        available.PushString(candidate);
	}
	
	if (available.Length == 0)
		return -1;
	
	int chosen = GetRandomInt(0, available.Length - 1);
	char result[PLATFORM_MAX_PATH];
	available.GetString(chosen, result, sizeof(result));
	
	for (int i = 0; i < g_Sounds.Length; i++)
	{
		char path[PLATFORM_MAX_PATH];
		g_Sounds.GetString(i, path, sizeof(path));
		
		if (StrEqual(path, result))
			return i;
	}
	
	return -1;
}

public Action Command_StopSound(int client, int args)
{
	if (IsValid(client))
	{
		if (IsMuted[client])
		{
			IsMuted[client] = false;
			
			CPrintToChat(client, "%s: %t", LOGO, "DIACRE_PlayerUnmute");
		}
		else
		{
			IsMuted[client] = true;
			
			CPrintToChat(client, "%s: %t", LOGO, "DIACRE_PlayerMute");
		}
	}
	
	return Plugin_Handled;
}

public Action Command_ToggleSound(int client, int args)
{
	if (IsValid(client))
	{
		if (PLUGIN_ACTIVE)
		{
			PLUGIN_ACTIVE = false;
		
			CPrintToChatAll("%s: %t", LOGO, "DIACRE_AutosoundStop", client);
		}
		else
		{
			PLUGIN_ACTIVE = true;
			
			CPrintToChatAll("%s: %t", LOGO, "DIACRE_AutosoundStart", client);
		}
	}
	
	return Plugin_Handled;
}

public IsValid(int client)
{
	if (client > 0 && client <= MaxClients && IsClientInGame(client))
		return true;
	else
		return false;
}

AddFolderToDownloadsTable(char[] Folder)
{
	if (DirExists(Folder))
	{
		Handle DIR = OpenDirectory(Folder);
		char BUFFER[PLATFORM_MAX_PATH];
		FileType FILETYPE = FileType_Unknown;
		
		while (ReadDirEntry(DIR, BUFFER, sizeof(BUFFER), FILETYPE))
		{
			if (!StrEqual(BUFFER, "") && !StrEqual(BUFFER, ".") && !StrEqual(BUFFER, ".."))
			{
				Format(BUFFER, sizeof(BUFFER), "%s/%s", Folder, BUFFER);
				if (FILETYPE == FileType_File)
				{
					if (FileExists(BUFFER, true) && IsFileDownloadable(BUFFER))
					{
						AddFileToDownloadsTable(BUFFER);
					}
				}
				else if (FILETYPE == FileType_Directory)
				{
					AddFolderToDownloadsTable(BUFFER);
				}
			}
		}
		
		CloseHandle(DIR);
	}
	else
	{
		LogError("[DiacrE]: Directory not exists - \"%s\"", Folder);
	}
}

bool  IsFileDownloadable(char[] string)
{
	char buffer[PLATFORM_MAX_PATH];
	GetFileExtension(string, buffer, sizeof(buffer));
	
	for (new i = 0; i < sizeof(ValidFormats); i++)
	{
		if (StrEqual(buffer, ValidFormats[i], false))
		{
			return true;
		}
	}
	
	return false;
}

bool GetFileExtension(const char[] filepath, char[] filetype, filetypelen)
{
	new loc = FindCharInString(filepath, '.', true);
	
	if(loc == -1)
	{
		filetype[0] = '\0';
		return false;
	}
	
	strcopy(filetype, filetypelen, filepath[loc + 1]);
	return true;
}

void LoadSoundList()
{
    if (!FileExists(CONFIG_PATH)) return;

    Handle file = OpenFile(CONFIG_PATH, "r");
    if (file == INVALID_HANDLE) return;

    char line[PLATFORM_MAX_PATH];
    while (!IsEndOfFile(file) && ReadFileLine(file, line, sizeof(line)))
    {
        TrimString(line);
        if (line[0] == ' ') continue;

        g_Sounds.PushString(line);
    }

    CloseHandle(file);
}