#include <sdktools>
#include <cstrike>
#include <morecolors>

#pragma semicolon 1

#define PLUGIN_AUTHOR "Dela"
#define PLUGIN_VERSION "1.0.1"

#define LOGO		"{green}[DiacrE]"

bool BombSiteChoose = false;

char ValidFormats[][] =
{
	"mdl", "phy", "vtx", "vvd",
	"vmt", "vtf", "png",
	"mp3", "wav"
};

public Plugin myinfo = 
{
	name = "[DiacrE] Choix BombSite",
	author = PLUGIN_AUTHOR,
	description = "[DiacrE] Choix BombSite",
	version = PLUGIN_VERSION,
	url = "www.diacre.org"
};

public void OnPluginStart()
{
	LoadTranslations("diacre_bombsite.phrases");
	
	HookEvent("round_start", OnRoundStart, EventHookMode_Pre);
	HookEvent("player_spawn", OnPlayerSpawn, EventHookMode_Pre);
	HookEvent("item_pickup", OnItemPickup, EventHookMode_Pre);
}

public void OnMapStart()
{
	AddFolderToDownloadsTable("sound");
	
	PrecacheSound("diacre_bombsite/a.wav", true);
	PrecacheSound("diacre_bombsite/b.wav", true);
}

public Action OnRoundStart(Handle event, char[] name, bool dontBroadcast)
{
	BombSiteChoose = false;
	
	return Plugin_Continue;
}

public Action OnPlayerSpawn(Handle event, const char[] name, bool dontBroadcast)
{
	int client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if (IsValidAndAlive(client) && GetClientTeam(client) == CS_TEAM_T)
	{
		if (PlayerHasC4(client))
		{
			if (!BombSiteChoose)
			{
				CreateTimer(1.0, Timer_Bombsite, client);
			}
		}
	}
	
	return Plugin_Continue;
}

public Action Timer_Bombsite(Handle timer, any client)
{
	if (IsValidAndAlive(client) && GetClientTeam(client) == CS_TEAM_T)
	{
		if (PlayerHasC4(client))
		{
			if (!BombSiteChoose)
			{
				OpenBombsiteMenu(client);
			}
		}
	}
	
	return Plugin_Continue;
}

public Action OnItemPickup(Handle event, const char[] name, bool dontBroadcast)
{
	int client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if (IsValidAndAlive(client) && GetClientTeam(client) == CS_TEAM_T)
	{
		if (PlayerHasC4(client))
		{
			if (!BombSiteChoose)
			{
				OpenBombsiteMenu(client);
			}
		}
	}
	
	return Plugin_Continue;
}

public bool PlayerHasC4(int client)
{
	if (IsValidAndAlive(client) && GetClientTeam(client) == CS_TEAM_T)
	{
		int bombe = GetPlayerWeaponSlot(client, CS_SLOT_C4);
		
		if (IsValidEntity(bombe))
		{
			char ClassName[32];
			GetEdictClassname(bombe, ClassName, sizeof(ClassName));
			
			if (StrEqual(ClassName, "weapon_c4"))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}

OpenBombsiteMenu(int client)
{
	if (IsValidAndAlive(client) && GetClientTeam(client) == CS_TEAM_T)
	{
		if (PlayerHasC4(client))
		{
			char Texte[64];
			
			Menu menu = new Menu(Menu_Bomb, MENU_ACTIONS_DEFAULT);
			
			menu.SetTitle("%t", "DIACRE_Bombsite_Menu");
			
			FormatEx(Texte, sizeof(Texte), "%t", "DIACRE_MenuChoice_A");
			menu.AddItem("A", Texte);
			
			FormatEx(Texte, sizeof(Texte), "%t", "DIACRE_MenuChoice_B");
			menu.AddItem("B", Texte);
			
			menu.ExitButton = false;
				
			menu.Display(client, 20);
		}
	}
}

public int Menu_Bomb(Menu menu, MenuAction action, int client, int param2) 
{ 
	switch (action)
	{
		case MenuAction_Select:
		{
			if (IsValidAndAlive(client) && GetClientTeam(client) == CS_TEAM_T)
			{
				if (PlayerHasC4(client))
				{
					char info[32];
					menu.GetItem(param2, info, sizeof(info));
					
					char SoundBomb[32];
					
					if(StrEqual(info, "A") || StrEqual(info, "B"))
					{
						Format(SoundBomb, sizeof(SoundBomb), "diacre_bombsite/%s.wav", info);
						
						for (int i = 1; i <= MaxClients; i++)
						{
							if (IsValid(i) && GetClientTeam(i) == CS_TEAM_T)
							{
								CPrintToChat(i, "%s: %t", LOGO, "DIACRE_ChatMessage", info);
								PrintCenterText(i, "%t", "DIACRE_CenterMessage", info);
								PrintHintText(i, "%t", "DIACRE_HintMessage", info);
								
								EmitSoundToClient(i, SoundBomb, _, SNDCHAN_STREAM, _, _, 1.0);
								
								BombSiteChoose = true;
							}
						}
					}
					else
					{
						PrintToServer("[Diacre BombSite]: Sound error.");
					}
				}
			}
		}
		
		case MenuAction_End:
		{ 
			delete menu;
		}
	}
	
	return Plugin_Continue;
}

public IsValid(int client)
{
	if (client > 0 && client <= MaxClients && IsClientInGame(client))
		return true;
	else
		return false;
}

public IsValidAndAlive(int client)
{
	if (client > 0 && client <= MaxClients && IsClientInGame(client) && IsPlayerAlive(client))
		return true;
	else
		return false;
}

AddFolderToDownloadsTable(char[] Folder)
{
	if (DirExists(Folder))
	{
		Handle DIR = OpenDirectory(Folder);
		char BUFFER[PLATFORM_MAX_PATH];
		FileType FILETYPE = FileType_Unknown;
		
		while (ReadDirEntry(DIR, BUFFER, sizeof(BUFFER), FILETYPE))
		{
			if (!StrEqual(BUFFER, "") && !StrEqual(BUFFER, ".") && !StrEqual(BUFFER, ".."))
			{
				Format(BUFFER, sizeof(BUFFER), "%s/%s", Folder, BUFFER);
				if (FILETYPE == FileType_File)
				{
					if (FileExists(BUFFER, true) && IsFileDownloadable(BUFFER))
					{
						AddFileToDownloadsTable(BUFFER);
					}
				}
				else if (FILETYPE == FileType_Directory)
				{
					AddFolderToDownloadsTable(BUFFER);
				}
			}
		}
		
		CloseHandle(DIR);
	}
	else
	{
		LogError("[DiacrE]: Directory not exists - \"%s\"", Folder);
	}
}

bool  IsFileDownloadable(char[] string)
{
	char buffer[PLATFORM_MAX_PATH];
	GetFileExtension(string, buffer, sizeof(buffer));
	
	for (new i = 0; i < sizeof(ValidFormats); i++)
	{
		if (StrEqual(buffer, ValidFormats[i], false))
		{
			return true;
		}
	}
	
	return false;
}

bool GetFileExtension(const char[] filepath, char[] filetype, filetypelen)
{
	new loc = FindCharInString(filepath, '.', true);
	
	if(loc == -1)
	{
		filetype[0] = '\0';
		return false;
	}
	
	strcopy(filetype, filetypelen, filepath[loc + 1]);
	return true;
}