#include <sourcemod>
#include <sdktools>
#include <cstrike>
#include <morecolors>

#pragma semicolon 1

#define PLUGIN_AUTHOR "Dela"
#define PLUGIN_VERSION "1.0.0"

#define LOGO				"{green}[DiacrE]"

char LogFile[PLATFORM_MAX_PATH];

public Plugin myinfo = 
{
	name = "[DiacrE] ClanTags",
	author = PLUGIN_AUTHOR,
	description = "[DiacrE] ClanTags",
	version = PLUGIN_VERSION,
	url = "www.diacre.org"
};

public void OnPluginStart()
{
	HookEvent("player_spawn", OnPlayerSpawn);
	
	char DateOfTheDay[64];
	int GameTime = GetTime();
	
	FormatTime(DateOfTheDay, sizeof(DateOfTheDay), "%d_%m_%Y", GameTime);
	
	BuildPath(Path_SM, LogFile, sizeof(LogFile), "logs/diacre_clantags_%s.log", DateOfTheDay);
}

public Action OnPlayerSpawn(Handle event, char[] name, bool dontBroadcast)
{
	int client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if (IsValidAndAlive(client))
	{
		if (GetClientTeam(client) > 1)
		{
			SetTag(client);
		}
	}
}

public void OnClientSettingsChanged(int client)
{
	if (IsValid(client) && GetClientTeam(client) > 1)
	{
		SetTag(client);
	}
}

stock SetTag(int client)
{
	if (IsValid(client))
	{
		CS_SetClientClanTag(client, "");
	}
}

public IsValid(int client)
{
	if (client > 0 && client <= MaxClients && IsClientInGame(client) && !IsFakeClient(client))
		return true;
	else
		return false;
}

public IsValidAndAlive(int client)
{
	if (client > 0 && client <= MaxClients && IsClientInGame(client) && IsPlayerAlive(client))
		return true;
	else
		return false;
}