#include <sourcemod>
#include <sdktools>
#include <morecolors>
#include <geoip>

#pragma semicolon 1

#define PLUGIN_AUTHOR "Dela"
#define PLUGIN_VERSION "1.0.7"

#define LOGO		"{green}[DiacrE]"

public Plugin myinfo = 
{
	name = "[DiacrE] Connect Announcer",
	author = PLUGIN_AUTHOR,
	description = "[DiacrE] Connect Announcer",
	version = PLUGIN_VERSION,
	url = "www.diacre.org"
};

public void OnPluginStart()
{
	LoadTranslations("diacre_connect_css.phrases");
	
	HookEvent("player_connect_client", event_PlayerConnect, EventHookMode_Pre);
	HookEvent("player_disconnect", event_PlayerDisconnect_Suppress, EventHookMode_Pre);
}

public Action event_PlayerConnect(Handle event, char[] name, bool dontBroadcast)
{
	char ip[3]; 
	GetEventString(event, "address", ip, sizeof(ip));
	
	if (StrEqual(ip, "")) 
		return Plugin_Handled;
	else 
		return Plugin_Continue;
}

public Action event_PlayerDisconnect_Suppress(Handle event, char[] name, bool dontBroadcast)
{
	if (!dontBroadcast)
	{
		char clientName[33]; 
		char networkID[22]; 
		char reason[65];
		
		GetEventString(event, "name", clientName, sizeof(clientName));
		GetEventString(event, "networkid", networkID, sizeof(networkID));
		GetEventString(event, "reason", reason, sizeof(reason));
		
		Handle newEvent = CreateEvent("player_disconnect", true);
		SetEventInt(newEvent, "userid", GetEventInt(event, "userid"));
		SetEventString(newEvent, "reason", reason);
		SetEventString(newEvent, "name", clientName);        
		SetEventString(newEvent, "networkid", networkID);

		FireEvent(newEvent, true);
		
		return Plugin_Handled;
	}

	return Plugin_Continue;
}

public Action OnClientPreAdminCheck(int client)
{
	if (!IsFakeClient(client))
	{
		char clientName[MAX_NAME_LENGTH]; 
		char networkID[64];
		char clientIP[24];
		char clientCountry[64];
		
		GetClientName(client, clientName, sizeof(clientName));
		GetClientAuthId(client, AuthId_Steam2, networkID, sizeof(networkID));
		GetClientIP(client, clientIP, sizeof(clientIP));
		GeoipCountry(clientIP, clientCountry, sizeof(clientCountry));
		
		CPrintToChatAll("%s: %t", LOGO, "DIACRE_Connect", clientName, networkID, clientCountry);
	}
}

public void OnClientDisconnect(int client)
{
	if (IsClientInGame(client))
	{
		if (!IsFakeClient(client))
		{
			char clientName[MAX_NAME_LENGTH];
			char networkID[64];
			char address[32];
			char clientCountry[64];
			
			GetClientName(client, clientName, sizeof(clientName));
			GetClientAuthId(client, AuthId_Steam2, networkID, sizeof(networkID));
			GetClientIP(client, address, sizeof(address), false);
			GeoipCountry(address, clientCountry, sizeof(clientCountry));

			CPrintToChatAll("%s: %t", LOGO, "DIACRE_Disconnect", clientName, networkID, clientCountry);
			
			Handle newEvent = CreateEvent("player_disconnect", true);
			SetEventString(newEvent, "name", clientName);
			SetEventInt(newEvent, "index", client-1);
			SetEventInt(newEvent, "userid", GetClientUserId(client));
			SetEventString(newEvent, "networkid", networkID);
			SetEventString(newEvent, "address", address);
			FireEvent(newEvent, true);
		}
	}
}