#include <sourcemod>
#include <SteamWorks>

#pragma semicolon 1

#define PLUGIN_AUTHOR "Dela"
#define PLUGIN_VERSION "1.0.0"

public Plugin myinfo = 
{
	name = "[DiacrE] Family Sharing",
	author = PLUGIN_AUTHOR,
	description = "[DiacrE] Family Sharing",
	version = PLUGIN_VERSION,
	url = "www.diacre.org"
};

public SteamWorks_OnValidateClient(ownerauthid, authid)
{
	if (ownerauthid > 0 && ownerauthid != authid)
	{
		char SteamID[32];
		
		Format(SteamID, sizeof(SteamID), "STEAM_1:%d:%d", (authid & 1), (authid >> 1));
		
		int  client = GetIndexBySteamID(SteamID);
		
		if (client != -1)
		{
			KickClient(client, "Le partage de jeu est interdit sur nos serveurs.");
		}
	}
}

GetIndexBySteamID(const char[] SteamID)
{
	char AuthStringToCompareWith[32];
	
	for (new i = 1; i <= MaxClients; i++)
	{
		if (IsClientConnected(i) && GetClientAuthId(i, AuthId_Steam2, AuthStringToCompareWith, sizeof(AuthStringToCompareWith)) && StrEqual(AuthStringToCompareWith, SteamID))
		{
			return i;
		}
	}
	
	return -1;
}