#include <sourcemod>
#include <sdktools>
#include <cstrike>
#include <morecolors>

#pragma semicolon 1

#define PLUGIN_AUTHOR "Dela"
#define PLUGIN_VERSION "1.0.2"

public Plugin myinfo = 
{
	name = "[DiacrE] JoinTeam",
	author = PLUGIN_AUTHOR,
	description = "[DiacrE] JoinTeam",
	version = PLUGIN_VERSION,
	url = "www.diacre.org"
};

public void OnPluginStart()
{
	LoadTranslations("diacre_jointeam.phrases");
	
	HookEvent("player_team", OnPlayerTeam, EventHookMode_Pre);
}

public Action OnPlayerTeam(Handle event, const char[] name, bool dontBroadcast)
{
	int client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if (IsValid(client) && !IsFakeClient(client))
	{
		if (GetEventInt(event, "team") == CS_TEAM_SPECTATOR)
		{
			CPrintToChatAll("%t", "DIACRE_JoinSpectator", client);
		}
		else if (GetEventInt(event, "team") == CS_TEAM_T)
		{
			CPrintToChatAll("%t", "DIACRE_JoinTerrorist", client);
		}
		else if (GetEventInt(event, "team") == CS_TEAM_CT)
		{
			CPrintToChatAll("%t", "DIACRE_JoinCTerrorist", client);
		}
	}
	
	return Plugin_Handled;
}

public IsValid(int client)
{
	if (client > 0 && client <= MaxClients && IsClientInGame(client))
		return true;
	else
		return false;
}