#include <sourcemod>
#include <morecolors>

#pragma semicolon 1

#define PLUGIN_AUTHOR "ProdigySim / Dela"
#define PLUGIN_VERSION "1.0.0"

#define LOGO		"{green}[DiacrE]"

#define MAX(%0,%1) (((%0) > (%1)) ? (%0) : (%1))

public Plugin myinfo = 
{
	name = "[DiacrE] LerpTracker",
	author = PLUGIN_AUTHOR,
	description = "[DiacrE] LerpTracker Update",
	version = PLUGIN_VERSION,
	url = "www.diacre.org"
};

float g_fCurrentLerps[MAXPLAYERS+1];

Handle hAnnounceLerp;
Handle hFixLerpValue;
Handle hMaxLerpValue;

Handle hMinUpdateRate;
Handle hMaxUpdateRate;
Handle hMinInterpRatio;
Handle hMaxInterpRatio;

#define ShouldFixLerp() (GetConVarBool(hFixLerpValue))

#define ShouldAnnounceLerpChanges() (GetConVarBool(hAnnounceLerp))

#define ShouldAnnounceInitialLerp() (GetConVarInt(hAnnounceLerp) == 1)

#define IsCurrentLerpValid(%0) (g_fCurrentLerps[(%0)] >= 0.0)

#define InvalidateCurrentLerp(%0) (g_fCurrentLerps[(%0)] = -1.0)

#define GetCurrentLerp(%0) (g_fCurrentLerps[(%0)])
#define SetCurrentLerp(%0,%1) (g_fCurrentLerps[(%0)] = (%1))

public void OnPluginStart()
{
	LoadTranslations("diacre_lerptracker.phrases");
	
	hMinUpdateRate = FindConVar("sv_minupdaterate");
	hMaxUpdateRate = FindConVar("sv_maxupdaterate");
	hMinInterpRatio = FindConVar("sv_client_min_interp_ratio");
	hMaxInterpRatio= FindConVar("sv_client_max_interp_ratio");
	hAnnounceLerp = CreateConVar("sm_announce_lerp", "2", "Annonce les changements de Lerp. 1=Annonce les Lerp initial et les changements 2=Annonce les changements uniquement", FCVAR_PLUGIN);
	hFixLerpValue = CreateConVar("sm_fixlerp", "0", "Correction du serrage incorrect des valeurs Lerp lorsque interp_ratio 0 est autorisé", FCVAR_PLUGIN);
	hMaxLerpValue = CreateConVar("sm_max_interp", "0.5", "Expulser les joueurs dont les paramètres dépassent cette limite supérieure difficile pour les lerps joueurs.", FCVAR_PLUGIN);
	
	AutoExecConfig(true, "diacre_lerptracker");
	
	RegAdminCmd("sm_lerps", Lerps_Cmd, ADMFLAG_BAN, "Liste les LERPS de tout les joueurs.");
	
	ScanAllPlayersLerp();
}

public void OnClientDisconnect_Post(int client)
{
	InvalidateCurrentLerp(client);
}

public void OnClientSettingsChanged(int client)
{
	if (IsValidEntity(client) &&  !IsFakeClient(client))
	{
		ProcessPlayerLerp(client);
	}
}

public Action Lerps_Cmd(int client, int args)
{
	if (IsClientInGame(client))
	{
		int lerpcnt;
		
		CPrintToChat(client, "%s: %t", LOGO, "DIACRE_AdminMsg");
		
		for (int rclient=1; rclient <= MaxClients; rclient++)
		{
			if (IsClientInGame(rclient) && !IsFakeClient(rclient))
			{
				PrintToConsole(client, "[DiacrE]: %02d. %N Lerp: %.01f", ++lerpcnt, rclient, (GetCurrentLerp(rclient) * 1000));
			}
		}
	}
	
	return Plugin_Handled;
}

ScanAllPlayersLerp()
{
	for (int client=1; client <= MaxClients; client++)
	{
		InvalidateCurrentLerp(client);
		
		if (IsClientInGame(client) && !IsFakeClient(client))
		{
			ProcessPlayerLerp(client);
		}
	}
}

ProcessPlayerLerp(int client)
{	
	float m_fLerpTime = GetEntPropFloat(client, Prop_Data, "m_fLerpTime");
	
	if (ShouldFixLerp())
	{
		m_fLerpTime = GetLerpTime(client);
		SetEntPropFloat(client, Prop_Data, "m_fLerpTime", m_fLerpTime);
	}
	
	if (IsCurrentLerpValid(client))
	{
		if (m_fLerpTime != GetCurrentLerp(client))
		{
			if (ShouldAnnounceLerpChanges())
			{
				CPrintToChatAll("%s: %t", LOGO, "DIACRE_LerpChanged", client, GetCurrentLerp(client)*1000, m_fLerpTime*1000);
			}
		}
	}
	else
	{
		if (ShouldAnnounceInitialLerp())
		{
			CPrintToChatAll("%s: %t", LOGO, "DIACRE_LerpSet", client, m_fLerpTime*1000);
		}
	}
	
	float max = GetConVarFloat(hMaxLerpValue);
	
	if(m_fLerpTime > max)
	{
		KickClient(client, "%t", "DIACRE_KickMsg", m_fLerpTime*1000, max*1000);
		CPrintToChatAll("%s: %t", LOGO, "DIACRE_KickMsgAll", client, m_fLerpTime*1000, max*1000);
	}
	else
	{
		SetCurrentLerp(client, m_fLerpTime);
	}
}

stock float GetLerpTime(int client)
{
	char buf[64]; 
	float lerpTime;
	
#define QUICKGETCVARVALUE(%0) (GetClientInfo(client, (%0), buf, sizeof(buf)) ? buf : "")
	
	int updateRate = StringToInt( QUICKGETCVARVALUE("cl_updaterate") );
	updateRate = RoundFloat(clamp(float(updateRate), GetConVarFloat(hMinUpdateRate), GetConVarFloat(hMaxUpdateRate)));
	
	float flLerpRatio = StringToFloat( QUICKGETCVARVALUE("cl_interp_ratio") );

	float flLerpAmount = StringToFloat( QUICKGETCVARVALUE("cl_interp") );

	
	if (hMinInterpRatio != INVALID_HANDLE && hMaxInterpRatio != INVALID_HANDLE && GetConVarFloat(hMinInterpRatio) != -1.0 )
	{
		flLerpRatio = clamp( flLerpRatio, GetConVarFloat(hMinInterpRatio), GetConVarFloat(hMaxInterpRatio) );
	}
	
	lerpTime = MAX( flLerpAmount, flLerpRatio / updateRate );
	
#undef QUICKGETCVARVALUE
	return lerpTime;
}

stock float clamp(float val, float low, float high)
{
	return val > high ? high : (val < low ? low : val);
}