#include <sdktools>
#include <morecolors>
#include <cstrike>

#pragma semicolon 1

#define PLUGIN_AUTHOR "Dela"
#define PLUGIN_VERSION "1.0.2"

#define LOGO		"{lightgreen}[{blue}DiacrE Objectifs{lightgreen}]"

Handle cvar_planting_bonus;
Handle cvar_planting_bonus_money_team;
Handle cvar_exploding_bonus_money_team;
Handle cvar_dropping_malus;
Handle cvar_rescue_bonus;
Handle cvar_rescue_bonus_money_team;
Handle cvar_hkill_malus;
Handle cvar_begindefuse_bonus_money_team;
Handle cvar_defused_bonus_money_team;
Handle cvar_objectifrescue_bonus_money_team;
Handle cvar_ctwinround_bonus_money_team;

int g_iAccount = -1;

bool BonusAlreadyGived = false;
bool BombIsPlanted = false;

public Plugin myinfo = 
{
	name = "[DiacrE] Objectif",
	author = PLUGIN_AUTHOR,
	description = "[DiacrE] Objectif",
	version = PLUGIN_VERSION,
	url = "www.diacre.org"
};

public void OnPluginStart()
{
	LoadTranslations("diacre_objectif.phrases");
	
	g_iAccount = FindSendPropInfo("CCSPlayer", "m_iAccount");
	
	if (g_iAccount == -1)
	{
		PrintToServer("[DiacrE]: Impossible de charger les offset.");
		return;
	}
	
	cvar_planting_bonus = CreateConVar("sm_diacre_bonus_plant", "1", "frags bonus lorsqu'on plante la bombe", FCVAR_PLUGIN, true, 1.0);
	cvar_planting_bonus_money_team = CreateConVar("sm_diacre_bonus_plant_money_team", "2000", "$$$ bonus lorsqu'on plante la bombe (équipe:T)", FCVAR_PLUGIN);
	cvar_exploding_bonus_money_team = CreateConVar("sm_diacre_bonus_explode_money_team", "2000", "$$$ bonus lorsque la bombe explose (équipe:T)", FCVAR_PLUGIN);
	cvar_dropping_malus = CreateConVar("sm_diacre_malus_drop", "1", "frags malus lorsqu'on drop la bombe", FCVAR_PLUGIN, true, 1.0);
	cvar_rescue_bonus = CreateConVar("sm_diacre_bonus_rescue", "1", "frags bonus lorsqu'on sauve un otage", FCVAR_PLUGIN, true, 1.0);
	cvar_rescue_bonus_money_team = CreateConVar("sm_diacre_bonus_rescue_money_team", "1000", "$$$ bonus lorsqu'on sauve un otage (équipe:CT | maps: CS_)", FCVAR_PLUGIN, true);
	cvar_objectifrescue_bonus_money_team = CreateConVar("sm_diacre_bonus_objectifrescue_money_team", "4000", "$$$ bonus lorsque l'équipe T a remporté le round sur une map CS_ (équipe:T | maps: CS_)", FCVAR_PLUGIN);
	cvar_begindefuse_bonus_money_team = CreateConVar("sm_diacre_bonus_begindefuse_money_team", "2000", "$$$ bonus lorsqu'un CT tente de désamorcer la bombe (1x/équipe/round:CT)", FCVAR_PLUGIN);
	cvar_defused_bonus_money_team = CreateConVar("sm_diacre_bonus_defused_money_team", "2000", "$$$ bonus lorsqu'un CT a désamorcé la bombe (équipe:CT)", FCVAR_PLUGIN);
	cvar_ctwinround_bonus_money_team = CreateConVar("sm_diacre_bonus_ctwinround_money_team", "4000", "$$$ bonus lorsque les CT empêchent de poser la bombe (équipe:CT | maps : DE_)", FCVAR_PLUGIN);
	cvar_hkill_malus = CreateConVar("sm_diacre_malus_hkill", "1", "frags malus lorsqu'on tue un otage", FCVAR_PLUGIN, true, 1.0);
	
	AutoExecConfig(true, "diacre_objectif");
	
	HookEvent("round_start", OnRoundStart, EventHookMode_Pre);
	HookEvent("round_end", OnRoundEnd, EventHookMode_Pre);
	HookEvent("bomb_planted", OnBombPlanted, EventHookMode_Pre);
	HookEvent("bomb_exploded", OnBombExploded, EventHookMode_Pre);
	HookEvent("bomb_dropped", OnBombDropped, EventHookMode_Pre);
	HookEvent("bomb_begindefuse", OnBombBeginDefuse, EventHookMode_Pre);
	HookEvent("bomb_defused", OnBombDefused, EventHookMode_Pre);
	HookEvent("hostage_rescued", OnHostageRescue, EventHookMode_Pre);
	HookEvent("hostage_killed", OnHostageKilled, EventHookMode_Pre);
}

public Action OnRoundStart(Handle event, const char[] name, bool dontBroadcast)
{
	BonusAlreadyGived = false;
	BombIsPlanted = false;
	
	return Plugin_Continue;
}

public Action OnRoundEnd(Handle event, const char[] name, bool dontBroadcast)
{
	int winner_team = GetEventInt(event, "winner");
	
	char CurrentMap[128];
	GetCurrentMap(CurrentMap, sizeof(CurrentMap));
	
	if (winner_team == CS_TEAM_T)
	{
		if (StrContains(CurrentMap, "cs_") != -1)
		{
			int money_team_player;
			
			for (int i = 1; i <= MaxClients; i++)
			{
				if (IsValid(i) && GetClientTeam(i) == CS_TEAM_T)
				{
					money_team_player = GetEntProp(i, Prop_Send, "m_iAccount") + GetConVarInt(cvar_objectifrescue_bonus_money_team);
					
					Diacre_UpdateMoney(i, money_team_player);
				}
			}
			
			CPrintToChatAll("%s: %t", LOGO, "DIACRE_BonusObjectifRescue", GetConVarInt(cvar_objectifrescue_bonus_money_team));
		}
	}
	else if (winner_team == CS_TEAM_CT)
	{
		if (StrContains(CurrentMap, "de_") != -1)
		{
			if (!BombIsPlanted)
			{
				int money_team_player;
			
				for (int i = 1; i <= MaxClients; i++)
				{
					if (IsValid(i) && GetClientTeam(i) == CS_TEAM_CT)
					{
						money_team_player = GetEntProp(i, Prop_Send, "m_iAccount") + GetConVarInt(cvar_ctwinround_bonus_money_team);
						
						Diacre_UpdateMoney(i, money_team_player);
					}
				}
				
				CPrintToChatAll("%s: %t", LOGO, "DIACRE_BonusCtWinRound", GetConVarInt(cvar_ctwinround_bonus_money_team));
			}
		}
	}
	
	return Plugin_Continue;
}

public Action OnBombPlanted(Handle event, const char[] name, bool dontBroadcast)
{
	int client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if (IsValid(client))
	{
		int score = GetClientFrags(client) + GetConVarInt(cvar_planting_bonus);
		SetEntProp(client, Prop_Data, "m_iFrags", score);
		
		int money_team_player;
		
		for (int i = 1; i <= MaxClients; i++)
		{
			if (IsValid(i) && GetClientTeam(i) == CS_TEAM_T)
			{
				money_team_player = GetEntProp(i, Prop_Send, "m_iAccount") + GetConVarInt(cvar_planting_bonus_money_team);
				
				Diacre_UpdateMoney(i, money_team_player);
			}
		}
		
		CPrintToChatAll("%s: %t", LOGO, "DIACRE_BonusPlanted", client, GetConVarInt(cvar_planting_bonus), GetConVarInt(cvar_planting_bonus_money_team));
		
		BombIsPlanted = true;
	}
	
	return Plugin_Continue;
}

public Action OnBombExploded(Handle event, const char[] name, bool dontBroadcast)
{
	int client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if (IsValid(client))
	{
		int money_team_player;
			
		for (int i = 1; i <= MaxClients; i++)
		{
			if (IsValid(i) && GetClientTeam(i) == CS_TEAM_T)
			{
				money_team_player = GetEntProp(i, Prop_Send, "m_iAccount") + GetConVarInt(cvar_exploding_bonus_money_team);
				
				Diacre_UpdateMoney(i, money_team_player);
			}
		}
		
		CPrintToChatAll("%s: %t", LOGO, "DIACRE_BonusExploded", client, GetConVarInt(cvar_exploding_bonus_money_team));
	}
	
	return Plugin_Continue;
}

public Action OnBombDropped(Handle event, const char[] name, bool dontBroadcast)
{
	int client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if (IsValidAndAlive(client) && GetClientHealth(client) > 0)
	{
		int score = GetClientFrags(client) - GetConVarInt(cvar_dropping_malus);
		SetEntProp(client, Prop_Data, "m_iFrags", score);
		
		CPrintToChatAll("%s: %t", LOGO, "DIACRE_MalusDropped", client, GetConVarInt(cvar_dropping_malus));
	}
	
	return Plugin_Continue;
}

public Action OnBombBeginDefuse(Handle event, const char[] name, bool dontBroadcast)
{
	int client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if (IsValid(client))
	{
		if (!BonusAlreadyGived)
		{
			BonusAlreadyGived = true;
			
			int money_team_player;
			
			for (int i = 1; i <= MaxClients; i++)
			{
				if (IsValid(i) && GetClientTeam(i) == CS_TEAM_CT)
				{
					money_team_player = GetEntProp(i, Prop_Send, "m_iAccount") + GetConVarInt(cvar_begindefuse_bonus_money_team);
					
					Diacre_UpdateMoney(i, money_team_player);
					
					CPrintToChat(i, "%s: %t", LOGO, "DIACRE_BonusBeginDefuse", client, GetConVarInt(cvar_begindefuse_bonus_money_team));
				}
			}
		}
	}
	
	return Plugin_Continue;
}

public Action OnBombDefused(Handle event, const char[] name, bool dontBroadcast)
{
	int client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if (IsValid(client))
	{
		int money_team_player;
			
		for (int i = 1; i <= MaxClients; i++)
		{
			if (IsValid(i) && GetClientTeam(i) == CS_TEAM_CT)
			{
				money_team_player = GetEntProp(i, Prop_Send, "m_iAccount") + GetConVarInt(cvar_defused_bonus_money_team);
				
				Diacre_UpdateMoney(i, money_team_player);
			}
		}
		
		CPrintToChatAll("%s: %t", LOGO, "DIACRE_BonusDefused", client, GetConVarInt(cvar_defused_bonus_money_team));
	}
	
	return Plugin_Continue;
}

public Action OnHostageRescue(Handle event, const char[] name, bool dontBroadcast)
{
	int client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if (IsValid(client))
	{
		int score = GetClientFrags(client) + GetConVarInt(cvar_rescue_bonus);
		SetEntProp(client, Prop_Data, "m_iFrags", score);
		
		int money_team_player;
		
		for (int i = 1; i <= MaxClients; i++)
		{
			if (IsValid(i) && GetClientTeam(i) == CS_TEAM_CT)
			{
				money_team_player = GetEntProp(i, Prop_Send, "m_iAccount") + GetConVarInt(cvar_rescue_bonus_money_team);
				
				Diacre_UpdateMoney(i, money_team_player);
			}
		}
		
		CPrintToChatAll("%s: %t", LOGO, "DIACRE_BonusRescue", client, GetConVarInt(cvar_rescue_bonus), GetConVarInt(cvar_rescue_bonus_money_team));
	}
	
	return Plugin_Continue;
}

public Action OnHostageKilled(Handle event, const char[] name, bool dontBroadcast)
{
	int client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if (IsValid(client))
	{
		int score = GetClientFrags(client) - GetConVarInt(cvar_hkill_malus);
		SetEntProp(client, Prop_Data, "m_iFrags", score);
		
		CPrintToChatAll("%s: %t", LOGO, "DIACRE_MalusHKill", client, GetConVarInt(cvar_hkill_malus));
	}
	
	return Plugin_Continue;
}

public IsValid(int client)
{
	if (client > 0 && client <= MaxClients && IsClientInGame(client))
		return true;
	else
		return false;
}

public IsValidAndAlive(int client)
{
	if (client > 0 && client <= MaxClients && IsClientInGame(client) && IsPlayerAlive(client))
		return true;
	else
		return false;
}

public Diacre_UpdateMoney(int client, int amount)
{
	if (g_iAccount != -1)
	{
		SetEntData(client, g_iAccount, amount);
	}
}