#include <sourcemod>
#include <sdktools>
#include <morecolors>

#pragma semicolon 1

#define PLUGIN_AUTHOR "Dela"
#define PLUGIN_VERSION "1.0.2"

#define LOGO		"{green}[DiacrE]"

public Plugin myinfo = 
{
	name = "[DiacrE] ResetScore",
	author = PLUGIN_AUTHOR,
	description = "[DiacrE] ResetScore",
	version = PLUGIN_VERSION,
	url = "www.diacre.org"
};

public void OnPluginStart()
{
	LoadTranslations("diacre_resetscore.phrases");
	
	RegConsoleCmd("sm_resetscore", Command_Reset);
	RegConsoleCmd("sm_reset", Command_Reset);
	RegConsoleCmd("sm_rs", Command_Reset);
}

public Action Command_Reset(int client, int args)
{
	if (IsClientInGame(client))
	{
		if(GetClientDeaths(client) == 0 && GetClientFrags(client) == 0)
		{
			CPrintToChat(client, "%s: %t", LOGO, "DIACRE_AlreadyReset");
		}
		else
		{
			CPrintToChat(client, "%s: %t", LOGO, "DIACRE_ResetScore", GetClientFrags(client), GetClientDeaths(client));
			
			SetEntProp(client, Prop_Data, "m_iFrags", 0);
			SetEntProp(client, Prop_Data, "m_iDeaths", 0);
		}
	}
}