#include <sourcemod>
#include <clients>
#include <sdktools>

#pragma semicolon 1

#define PLUGIN_AUTHOR "Dela"
#define PLUGIN_VERSION "1.0.0"

public Plugin myinfo = 
{
	name = "[DiacrE] Round End No Damage",
	author = PLUGIN_AUTHOR,
	description = "[DiacrE] Round End No Damage",
	version = PLUGIN_VERSION,
	url = "www.diacre.org"
};

public void OnPluginStart()
{
	HookEvent("round_start", OnRoundStart);
	HookEvent("round_end", OnRoundEnd, EventHookMode_Pre);
}

public Action OnRoundStart(Handle event, char[] name, bool dontBroadcast)
{
	for (int players = 1; players < MaxClients; players++)
	{
		if (IsValidAndAlive(players))
		{
			SetEntProp(players, Prop_Data, "m_takedamage", 2, 1);
		}
	}
	
	return Plugin_Continue;
}

public Action OnRoundEnd(Handle event, const char[] name, bool dontBroadcast)
{
	for (int players = 1; players < MaxClients; players++)
	{
		if (IsValidAndAlive(players))
		{
			SetEntProp(players, Prop_Data, "m_takedamage", 0, 1);
		}
	}
	
	return Plugin_Continue;
}

public IsValidAndAlive(int client)
{
	if (client > 0 && client <= MaxClients && IsClientInGame(client) && IsPlayerAlive(client))
		return true;
	else
		return false;
}