#include <sourcemod>
#include <sdktools>

#pragma semicolon 1

#define PLUGIN_AUTHOR "Dela"
#define PLUGIN_VERSION "1.0.0"

#define SOUND_VOTEMAP	"diacre/votestart.mp3"

public Plugin myinfo = 
{
	name = "[DiacrE] MapVote",
	author = PLUGIN_AUTHOR,
	description = "[DiacrE] MapVote",
	version = PLUGIN_VERSION,
	url = "www.diacre.org"
};

public void OnMapStart()
{
	AddFileToDownloadsTable("sound/diacre/votestart.mp3");
	
	PrecacheSound(SOUND_VOTEMAP, true);
}

public void OnMapVoteStarted()
{
	for (int i = 1; i < MaxClients; i++)
	{
		if (IsValid(i))
		{
			EmitSoundToClient(i, SOUND_VOTEMAP, _, _, _, _, 1.0);
		}
	}
}

public IsValid(int client)
{
	if (client > 0 && client <= MaxClients && IsClientInGame(client))
		return true;
	else
		return false;
}