<?php

class BannedAvatar_XenForo_DataWriter_User extends XFCP_BannedAvatar_XenForo_DataWriter_User
{
	protected function _postSave()
	{
		parent::_postSave();

		/**
		 * Nasty little hack to fix bug whereby the unbanned user keeps the cache buster and
		 * causes it to look like their avatar has been deleted when in reality they never had one.
		 */
		if ($this->isUpdate() && $this->getExisting('is_banned') == true && $this->get('avatar_date'))
		{
			/** @var XenForo_Model_Avatar $avatarModel */
			$avatarModel = $this->getModelFromCache('XenForo_Model_Avatar');
			$avatarPath = $avatarModel->getAvatarFilePath($this->get('user_id'), 's');

			if (!file_exists($avatarPath))
			{
				$this->_db->update('xf_user', array(
					'avatar_date' => 0,
					'avatar_width' => 0,
					'avatar_height' => 0
				), 'user_id = ' . $this->_db->quote($this->get('user_id')));
			}
		}
	}
}

// ******************** FOR IDE AUTO COMPLETE ********************
if (false)
{
	class XFCP_BannedAvatar_XenForo_DataWriter_User extends XenForo_DataWriter_User {}
}