<?php
  

class Dark_PostRating_Deferred_ConvertLikes extends XenForo_Deferred_Abstract {
	
	const PER_PAGE = 500;
	
	public function execute(array $deferred, array $data, $targetRunTime, &$status){
		$data = array_merge(array(
			'page' => 0,
		), $data);
			
		/* @var Dark_PostRating_Model */
		$ratingModel = XenForo_Model::create('Dark_PostRating_Model');
		
		if(!$ratingModel->convertRatingsToLikes($data['page'], self::PER_PAGE))
			return false;
		
		$rbPhrase = new XenForo_Phrase('dark_postrating_converting_likes');
		$status = sprintf('%s... (%s)', $rbPhrase, XenForo_Locale::numberFormat($data['page'] * self::PER_PAGE));

		$data['page'] ++;
		
		return $data;		
	}
		
	public function canCancel(){
		return true;
	}
}