<?php
  

class Dark_PostRating_Deferred_ReceivedCount extends XenForo_Deferred_Abstract {
	
	const PER_PAGE = 1000;
	
	public function execute(array $deferred, array $data, $targetRunTime, &$status){
		$data = array_merge(array(
			'page' => 0,
		), $data);
			
		/* @var Dark_PostRating_Model */
		$ratingModel = XenForo_Model::create('Dark_PostRating_Model');
		
		if(!$ratingModel->populateCountReceived($data['page'], self::PER_PAGE))
			return false;
		
		$rbPhrase = new XenForo_Phrase('rebuilding');
		$typePhrase = new XenForo_Phrase('dark_ratings_received');
		$status = sprintf('%s... %s (%s)', $rbPhrase, $typePhrase, XenForo_Locale::numberFormat($data['page'] * self::PER_PAGE));

		$data['page'] ++;
		
		return $data;		
	}
		
	public function canCancel(){
		return true;
	}
}