<?php
  
class Dark_PostRating_Model_Like extends XFCP_Dark_PostRating_Model_Like {
	
	public function likeContent($contentType, $contentId, $contentUserId, $likeUserId = null, $likeDate = null)
	{
		$result = parent::likeContent($contentType, $contentId, $contentUserId, $likeUserId, $likeDate);
		
		if($result && $contentType == 'post'){
			
			$visitor = XenForo_Visitor::getInstance();

			if ($likeUserId === null){
				$likeUserId = $visitor['user_id'];
			}
		
			// delete any ratings on this post
			// (prevents both a like and a rating where likeContent is called from something outside post ratings like tapatalk)
			/** @var Dark_PostRating_Model */
			$ratingModel = XenForo_Model::create('Dark_PostRating_Model');
			$ratingModel->ratePost(array(
				'post_id' => $contentId,
				'user_id' => $contentUserId,
			), $likeUserId, 'del', true);			
			/*
			$db = $this->_getDb();
			$db->query('
				delete from dark_postrating where post_id = ? and user_id = ?
			', array($contentId, $likeUserId));	*/	
				
		}
		
		return $result;
	}
	
}