<?php

class EWRmedio_BbCode_Embed
{
	public static function embedMedio($key, array $site)
	{
		$keys = explode(';', $key);
		
		if ($media = XenForo_Model::create('EWRmedio_Model_Media')->getMediaByID($keys[0], false))
		{
			$viewParams = array(
				'media' => $media,
				'float' => empty($keys[1]) ? 'initial' : $keys[1],
			);
			
			if ($viewParams['float'] == 'full')
			{
				$bbCodeParser = new XenForo_BbCode_Parser(XenForo_BbCode_Formatter_Base::create('Base'));
				$viewParams['media']['media_description'] = new XenForo_BbCode_TextWrapper($viewParams['media']['media_description'], $bbCodeParser);

				$keywords = explode(",", $viewParams['media']['media_keywords']);
				foreach ($keywords AS &$keyword)
				{
					$keyword = trim($keyword);
					$keyword = '<a href="'.XenForo_Link::buildPublicLink('media/keyword', array('keyword_text' => $keyword)).'">'.$keyword.'</a>';
				}
				$viewParams['media']['media_keywords'] = implode(", ", $keywords);

				$template = new XenForo_Template_Public('EWRmedio_BBcode_Full', $viewParams);
			}
			else
			{
				$template = new XenForo_Template_Public('EWRmedio_BBcode', $viewParams);
			}
			
			return $template->render();
		}
		else
		{
			return '[MEDIA=xenmedio]'.$keys[0].'[/MEDIA]';
		}
	}
}