<?php

class EWRmedio_Model_Sitemap extends XFCP_EWRmedio_Model_Sitemap
{
	public function getSitemapPreamble()
	{
		$response = parent::getSitemapPreamble();
		
		return preg_replace('#<urlset(.*?)>#si',
			'<urlset$1 xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">',
			$response);
	}
	
	public function buildSitemapEntry(array $result)
	{
		$response = str_replace('</url>', '', parent::buildSitemapEntry($result));
		
		if (!empty($result['video']) && is_array($result['video']))
		{
			$response .= '<video:video>';
			foreach ($result['video'] AS $tag => $value)
			{
				if (is_array($value))
				{
					foreach ($value AS $subvalue)
					{
						$response .= "<video:$tag>" . htmlspecialchars($subvalue, ENT_QUOTES, 'UTF-8') . "</video:$tag>";
					}
				}
				else
				{
					$response .= "<video:$tag>" . htmlspecialchars($value, ENT_QUOTES, 'UTF-8') . "</video:$tag>";
				}
			}
			$response .= '</video:video>';
		}
		
		return $response.'</url>';
	}
}