<?php

class EWRporta_Block_Controller_RecentThreadx5i2 extends XFCP_EWRporta_Block_Controller_RecentThreadx5i2
{
	public function actionRecentThreadsi2()
	{
		$options = $this->getModelFromCache('EWRporta_Model_Options')->getOptionsByBlock('RecentThreadx5i2');
		$options = $this->getModelFromCache('EWRporta_Model_Options')->prepareOptions($options);
		
		$tab = $this->_input->filterSingle('tab', XenForo_Input::UINT);
		$pos = $this->_input->filterSingle('pos', XenForo_Input::STRING);
		
		switch ($tab)
		{
			case 5:
				$forum = $options['recentthreadx5i2_forum5']['option_value'];
				break;
			case 4:
				$forum = $options['recentthreadx5i2_forum4']['option_value'];
				break;
			case 3:
				$forum = $options['recentthreadx5i2_forum3']['option_value'];
				break;
			case 2:
				$forum = $options['recentthreadx5i2_forum2']['option_value'];
				break;
			default:
				$forum = $options['recentthreadx5i2_forum1']['option_value'];
				break;
		}
		
		$threads = $this->getModelFromCache('EWRporta_Block_RecentThreadx5i2')->getTab(
			$options['recentthreadx5i2_cutoff']['option_value'],
			$options['recentthreadx5i2_limit']['option_value'],
			$forum
		);
		
		$viewParams = array(
			'threads' => $threads,
			'position' => $pos,
		);

		return $this->responseView('EWRporta_Block_ViewPublic_RecentThreadx5i2', 'EWRblock_RecentThreadx5i2_Simple', $viewParams);
	}
}