<?php

class EWRutiles_Staff_ControllerPublic_Member extends XFCP_EWRutiles_Staff_ControllerPublic_Member
{
	public function actionIndex()
	{
		$type = $this->_input->filterSingle('type', XenForo_Input::STRING);
		
		if ($type == 'staff')
		{
			return $this->responseReroute(__CLASS__, 'staff-members');
		}
		
		return parent::actionIndex();
	}
	
	public function actionStaffMembers()
	{
		if (!XenForo_Application::getOptions()->EWRutiles_Staff_stafflist)
		{
			return $this->responseNoPermission();
		}
		
		$forumNodes = $this->getModelFromCache('XenForo_Model_Node')->getViewableNodeList();

		$moderatorIDs = array();
		$contentModeratorInfo = array();
		$contentModData = $this->getModelFromCache('XenForo_Model_Moderator')->addContentTitlesToModerators(
			$this->getModelFromCache('XenForo_Model_Moderator')->getContentModerators()
		);

		foreach ($contentModData AS $moderator)
		{
			if (!empty($forumNodes[$moderator['content_id']]))
			{
				$moderator['node_id'] = $moderator['content_id'];
				$contentModeratorInfo[$moderator['user_id']][] = $moderator;
			}
		}

		$superModerators = array();
		$contentModerators = array();
		foreach ($this->getModelFromCache('XenForo_Model_Moderator')->getAllGeneralModerators() AS $moderator)
		{
			$moderatorIDs[] = $moderator['user_id'];
			
			if ($moderator['is_super_moderator'])
			{
				$superModerators[$moderator['user_id']] = $moderator;
			}

			if (isset($contentModeratorInfo[$moderator['user_id']]))
			{
				$moderator['content'] = $contentModeratorInfo[$moderator['user_id']];
				$contentModerators[$moderator['user_id']] = $moderator;
			}
		}
		
		$moderators = $this->getModelFromCache('XenForo_Model_User')->getUsersByIds($moderatorIDs);

		foreach ($superModerators AS &$moderator)
		{
			$moderator['last_activity'] = $moderators[$moderator['user_id']]['last_activity'];
		}

		foreach ($contentModerators AS &$moderator)
		{
			$moderator['last_activity'] = $moderators[$moderator['user_id']]['last_activity'];
		}
		
		$administrators = $this->getModelFromCache('XenForo_Model_Admin')->prepareAdminRecords($this->getModelFromCache('XenForo_Model_Admin')->getAllAdmins());

		$staff = $this->getModelFromCache('XenForo_Model_User')->getUsers(array('is_staff' => true), array(
			'join' => XenForo_Model_User::FETCH_USER_FULL,
			'order' => 'username'
		));

		list($month, $day) = explode('/', XenForo_Locale::date(XenForo_Application::$time, 'n/j'));

		$criteria = array(
			'user_state' => 'valid',
			'is_banned' => 0
		);
		
		$birthdays = $this->getModelFromCache('XenForo_Model_User')->getBirthdayUsers($month, $day, $criteria, array(
			'join' => XenForo_Model_User::FETCH_USER_FULL,
			'limit' => 20
		));
		
		$viewParams = array(
			'administrators' => $administrators,
			'superModerators' => $superModerators,
			'contentModerators' => $contentModerators,
			'staff' => $staff,
			'birthdays' => $birthdays
		);
		
		return $this->responseView('EWRutiles_Staff_ViewPublic_StaffList', 'EWRutiles_Staff_StaffList', $viewParams);
	}
}