<?php

class EWRutiles_Staff_Listener_Template
{
	public static function template_hook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		$options = XenForo_Application::get('options');
		
		switch ($hookName)
		{
			case 'forum_view_pagenav_before':
			{
				if ($options->EWRutiles_Staff_modlist)
				{
					$modModel = XenForo_Model::create('XenForo_Model_Moderator');
					$conditions = array('content' => array('node', $hookParams['forum']['node_id']));
					$hookParams['moderators'] = $modModel->getContentModerators($conditions);
					$hookParams['modCount'] = count($hookParams['moderators']);

					$contents .= $template->create('EWRutiles_Staff_Moderators', $hookParams);
				}
				break;
			}
			case 'thread_list_stickies':
			{
				if ($options->EWRutiles_Staff_stickies && trim($contents))
				{
					$contents .= '<li class="sectionHeaders">&nbsp;</li>';
				}
				break;
			}
		}
	}
}