class SteamAuth_ControllerPublic_Steam extends XenForo_ControllerPublic_Abstract
{
    public function actionLogin()
    {
        require_once('lightopenid/openid.php'); // bibliothèque OpenID à inclure

        $openid = new LightOpenID($_SERVER['HTTP_HOST']);
        if (!$openid->mode) {
            $openid->identity = 'https://steamcommunity.com/openid';
            return $this->responseRedirect(
                XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL,
                $openid->authUrl()
            );
        } elseif ($openid->mode == 'cancel') {
            return $this->responseMessage('Authentification Steam annulée');
        } elseif ($openid->validate()) {
            preg_match("#https://steamcommunity.com/openid/id/(\d+)#", $openid->identity, $matches);
            $steamId = $matches[1];

            // À ce stade, tu peux rechercher un utilisateur existant ou en créer un
            return $this->responseMessage("Connecté avec SteamID : " . $steamId);
        }
    }
}