class SteamAuth_Model_Steam extends XenForo_Model
{
    public function install()
    {
        $db = $this->_getDb();
        $db->query("
            CREATE TABLE IF NOT EXISTS `xf_steam_user` (
                `steam_id` BIGINT UNSIGNED NOT NULL,
                `user_id` INT UNSIGNED NOT NULL,
                PRIMARY KEY (`steam_id`),
                FOREIGN KEY (`user_id`) REFERENCES `xf_user` (`user_id`) ON DELETE CASCADE
            )
        ");
    }

    public function linkSteamUserToXenForoUser($userId, $steamId)
    {
        $db = $this->_getDb();
        $db->query("
            INSERT INTO `xf_steam_user` (`user_id`, `steam_id`)
            VALUES (?, ?)
        ", array($userId, $steamId));
    }

    public function getSteamUserBySteamId($steamId)
    {
        return $this->_getDb()->fetchRow("
            SELECT * FROM `xf_steam_user`
            WHERE `steam_id` = ?
        ", $steamId);
    }
}