<?php

class XenForo_SpamHandler_ProfilePost extends XenForo_SpamHandler_Abstract
{
	/**
	 * Checks that the options array contains a non-empty 'delete_messages' key
	 *
	 * @param array $user
	 * @param array $options
	 *
	 * @return boolean
	 */
	public function cleanUpConditionCheck(array $user, array $options)
	{
		return !empty($options['delete_messages']);
	}

	/**
	 * @see XenForo_SpamHandler_Abstract::cleanUp()
	 */
	public function cleanUp(array $user, array &$log, &$errorKey)
	{
		if ($profilePosts = $this->getModelFromCache('XenForo_Model_ProfilePost')->getProfilePostsByUserId($user['user_id']))
		{
			$profilePostIds = array_keys($profilePosts);

			$this->getModelFromCache('XenForo_Model_SpamPrevention')->submitSpamCommentData('profile_post', $profilePostIds);

			$deleteType = (XenForo_Application::get('options')->spamMessageAction == 'delete' ? 'hard' : 'soft');

			$log['profile_post'] = array(
				'deleteType' => $deleteType,
				'profilePostIds' => $profilePostIds
			);

			$inlineModModel = $this->getModelFromCache('XenForo_Model_InlineMod_ProfilePost');
			$inlineModModel->enableLogging = false;

			$ret = $inlineModModel->deleteProfilePosts(
				$profilePostIds, array('deleteType' => $deleteType, 'skipPermissions' => true), $errorKey
			);
			if (!$ret)
			{
				return false;
			}
		}

		return true;
	}

	/**
	 * @see XenForo_SpamHandler_Abstract::restore()
	 */
	public function restore(array $log, &$errorKey = '')
	{
		if ($log['deleteType'] == 'soft')
		{
			$inlineModModel = $this->getModelFromCache('XenForo_Model_InlineMod_ProfilePost');
			$inlineModModel->enableLogging = false;

			return $inlineModModel->undeleteProfilePosts(
				$log['profilePostIds'], array('skipPermissions' => true), $errorKey
			);
		}

		return true;
	}
}