<?php

	class XenStaff_ControllerPublic_Index extends XenForo_ControllerPublic_Abstract
	{

		public function actionIndex()
		{

		$options = XenForo_Application::get('options');

		if (!$options->displaystaffActive)
		{
			return $this->responseError(new XenForo_Phrase('access_url_staff_off'));
		}


		$staffGroupsModel = $this->getModelFromCache('XenStaff_Model_StaffGroups');
		$staffGroupsUserIdsModel = $this->getModelFromCache('XenStaff_Model_StaffGroupsUserIds');
		$staffUserInfoModel = $this->getModelFromCache('XenForo_Model_User');
		$staffGroupsUniqueIdsModel = $this->getModelFromCache('XenStaff_Model_StaffGroupsUniqueIds');

		$staffGroups = $staffGroupsModel->getSelectedUserGroups();
		$staffGroupsUserIds = $staffGroupsUserIdsModel->getListofUsersPerStaffGroup();
		$staffIds = $staffGroupsUniqueIdsModel->getListofUniqueIds($staffGroupsUserIds);
		$staffUserInfo = $staffUserInfoModel->getUsersByIds($staffIds, $staffOptions = array());

		$visitor = XenForo_Visitor::getInstance();


		if ((!$options->displaystafftoAll) AND !(in_array($visitor['user_id'], $staffIds)))
		{
			return $this->responseError(new XenForo_Phrase('access_url_staff_only'));
		}


		$onlineUsers = $this->getModelFromCache('XenForo_Model_Session')->getSessionActivityQuickList(
			$visitor->toArray(),
			array('cutOff' => array('>', $this->getModelFromCache('XenForo_Model_Session')->getOnlineStatusTimeout())),
			($visitor['user_id'] ? $visitor->toArray() : null)
		);

	        $staffOnline = array();

		if (!empty($onlineUsers))
                {
		        foreach ($onlineUsers['records'] AS $staffId)
		        {

		                if (in_array($staffId['user_id'], $staffIds))
                                {
                                       $staffOnline[] = $staffId;
                                }

		        }

		}

		$viewParams = array(
			'staffgroups' => $staffGroups,
			'staffgroupsuserids' => $staffGroupsUserIds,
			'staffuserinfo' => $staffUserInfo,
			'staffonline' => $staffOnline
		);

			return $this->responseView('XenStaff_ViewPublic_Index', 'XenStaff_index', $viewParams);

		}

	}
