<?php

define('SITEMAP_FROM_CLI', true);

// disable limits
@set_time_limit(0);
ini_set('memory_limit', '256M');

// This one would be $ php library/XfAddOns/Sitemap/Cli.php
if (!is_file('./library/config.php'))
{
	// This one would be
	// $ cd library/XfAddOns/Sitemap/
	// $ php Cli.php
	chdir(dirname(__FILE__) . '/../../..');	
}

if (!is_file('./library/config.php'))
{
	print 'We do not appear to be running from the correct directory, needs to be XF root and the directory is: ' . getcwd() . "\r\n";;
	exit;
}
else
{
	print 'Running from directory: ' . getcwd() . "\r\n";
}

$startTime = microtime(true);
require('./library/XenForo/Autoloader.php');
XenForo_Autoloader::getInstance()->setupAutoloader('./library');

XenForo_Application::initialize('./library');
XenForo_Application::set('page_start_time', $startTime);
XenForo_Application::setDebugMode(false);

// make sure all the plugins load correctly
$dependencies = new XenForo_Dependencies_Public();
$dependencies->preLoadData();

$db = XenForo_Application::getDb();
$db->setProfiler(false);

// and run the sitemap
XfAddOns_Sitemap_CronEntry_RebuildSitemap::run();

