<?php

class XfAddOns_Sitemap_Install_Install
{

	/**
	 * We will refuse installation of the add-on if the version is not the minimally supported
	 * @throws XenForo_Exception
	 */
	public static function install($installedAddon)
	{
		@set_time_limit(0);
		@ignore_user_abort(true);
		
		if (XenForo_Application::$versionId < 1030070)
		{
			throw new XenForo_Exception('This add-on requires XenForo 1.3.0 or higher.', true);
		}
		
		$installer = new XfAddOns_Sitemap_Install_Install();
		$installer->runInstall($installedAddon);
	}
	
	/**
	 * Uninstall logic for the sitemap
	 */	
	public static function uninstall()
	{
		$installer = new XfAddOns_Sitemap_Install_Install();
		$installer->runUnInstall($installedAddon);
	}
	
	/**
	 * The actual install logic. this method has all the queries that are run along with the addon
	 * @param array $installedAddon	Data for the installed add-on
	 */
	public function runInstall($installedAddon)
	{
		// Trigger the version  specific table updates
		$version = is_array($installedAddon) ? $installedAddon['version_id'] : 0;
		if ($version < 150)
		{
			$this->executeQuery("ALTER TABLE xf_forum ADD xfa_sitemap TINYINT NOT NULL DEFAULT 1");
		}	
	}

	/**
	 * The actual uninstall logic. Removes anything setup by the add-on
	 * @param array $installedAddon	Data for the installed add-on
	 */
	public function runUnInstall($installedAddon)
	{
		$this->executeQuery("ALTER TABLE xf_forum DROP xfa_sitemap");		
	}
	
	/**
	 * Execute a query and ignore if it causes an exception
	 */
	public function executeQuery($sql, array $bind = array(), $logExceptions = false)
	{
		$db = XenForo_Application::getDb();
		try
		{
			return $db->query($sql, $bind);
		}
		catch (Zend_Db_Exception $ex)
		{
			if ($logExceptions)
			{
				XenForo_Error::logException($ex, false);
			}
			return false;
		}
	}	
	
}