<?php

class EWRmedio_SitemapHandler_Media extends XenForo_SitemapHandler_Abstract
{
	public function getRecords($previousLast, $limit, array $viewingUser)
	{
		if ($previousLast)
		{
			return array();
		}

		$mediaModel = XenForo_Model::create('EWRmedio_Model_Media');
		return $mediaModel->getAllMedias($previousLast, $limit);
	}

	public function isIncluded(array $entry, array $viewingUser)
	{
		if ($entry['media_state'] != 'visible')
		{
			return false;
		}

		return true;
	}

	public function getData(array $entry)
	{
		return array(
			'loc' => XenForo_Link::buildPublicLink('canonical:media/media', $entry),
			'lastmod' => $entry['media_date'],
			'video' => array(
				'thumbnail_loc' => EWRmedio_Template_Helper::getMedioHighUrl($entry),
				'player_loc' => XenForo_Link::buildPublicLink('canonical:media/media/embed', $entry),
				'title' => $entry['media_title'],
				'description' => XenForo_Helper_String::wholeWordTrim($entry['media_description'], 2048),
				'duration' => $entry['media_duration'],
				'publication_date' => gmdate(DateTime::W3C, $entry['media_date']),
				'tag' => explode(',', $entry['media_keywords']),
				'category' => $entry['category_name'],
			)
		);
	}

	public function isInterruptable()
	{
		return true;
	}
}