/**
 * vim: set ts=4 :
 * =============================================================================
 * Weapon Restriction w/ Warmup Plugin for SourceMod
 * Restricts weapons for Counter-Strike: Source.
 *
 * SourceMod (C)2004-2007 AlliedModders LLC.  All rights reserved.
 * =============================================================================
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 3.0, as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * As a special exception, AlliedModders LLC gives you permission to link the
 * code of this program (as well as its derivative works) to "Half-Life 2," the
 * "Source Engine," the "SourcePawn JIT," and any Game MODs that run on software
 * by the Valve Corporation.  You must obey the GNU General Public License in
 * all respects for all other code used.  Additionally, AlliedModders LLC grants
 * this exception to all derivative works.  AlliedModders LLC defines further
 * exceptions, found in LICENSE.txt (as of this writing, version JULY-31-2007),
 * or <http://www.sourcemod.net/license.php>.
 *
 */

#pragma semicolon 1
#include <sourcemod>
#include <cstrike>
#include <sdktools>
#undef REQUIRE_PLUGIN
#include <adminmenu>

#define CS_SLOT_KNIFE 2						// melee weapon slot
#define MAX_WEAPONS 35						// max weapons
#define VERSION "3.0.2"						// version information

#define WARMUP 1							// warmup system, 0 = off, 1 = on
#define STOCK_MENUS 1						// stock menus, 0 = off, 1 = on


/* TO BE DONE */
//sm_knifes
//sm_pistols
//sm_give

new String:g_WeaponNames[MAX_WEAPONS][ ] = 
{ 
    "primammo",      "secammo",   "vest",      "vesthelm",
    "defuser",       "nvgs",      "flashbang", "hegrenade",
    "smokegrenade",  "galil",     "ak47",      "scout",
    "sg552",         "awp",       "g3sg1",     "famas", 
    "m4a1",          "aug",       "sg550",     "glock",
    "usp",           "p228",      "deagle",    "elite",
    "fiveseven",     "m3",        "xm1014",    "mac10",
    "tmp",           "mp5navy",   "ump45",     "p90",
    "m249",          "c4",        "knife"
};

#if STOCK_MENUS
new Handle:hTopMenu             = INVALID_HANDLE;	// admin menu
#endif

new Handle:g_T_Restrictions     = INVALID_HANDLE;	// terrorist restrictions
new Handle:g_CT_Restrictions    = INVALID_HANDLE;	// counter-terrorist restrictions
new Handle:g_WeaponSlots        = INVALID_HANDLE;	// weapon slot info
new Handle:g_WeaponCosts        = INVALID_HANDLE;	// weapon cost info

new Handle:g_GroupNames         = INVALID_HANDLE;   // weapon group names - user defined / set
new Handle:g_GroupWeapons       = INVALID_HANDLE;	// weapon groups - user defined / set
new Handle:g_GroupLimits_CT     = INVALID_HANDLE;   // weapon group limits for CT's
new Handle:g_GroupLimits_T      = INVALID_HANDLE;   // weapon group limits for T's

new g_iAccount = -1;							// account offset for monies
new g_iOwner = -1;                              // owner offset for weapons

#if WARMUP
#include "restrict/warmup.sp"					// warmup system
#endif

#include "restrict/restrict_utils.sp"			// restrict utilities
#include "restrict/restrict_convars.sp"			// cVar handlers
#include "restrict/events.sp"					// event handling
#include "restrict/restrict_groups.sp"          // group handling for restrictions
#include "restrict/restrict_commands.sp"        // admin commands for handling restrictions

public Plugin:myinfo =
{
    name = "Weapon Restrictions",
    author = "Liam",
    description = "Handles weapon restrictions.",
    version = VERSION,
    url = "http://www.wcugaming.org/"
};

public OnPluginStart( )
{
    LoadTranslations("common.phrases");
    LoadTranslations("restrict.phrases");
    AutoExecConfig(true, "restrict_weapons");

    RegisterCommands( );
    RegisterADTData( );
    RegisterConVars( );
    HookConVars( );
    RegisterOffsets( );
    HookAllEvents( );
    LoadHacks( );

#if STOCK_MENUS
    /* Account for late loading */
    new Handle:topmenu;
    if (LibraryExists("adminmenu") && ((topmenu = GetAdminTopMenu()) != INVALID_HANDLE))
    {
        OnAdminMenuReady(topmenu);
    }
#endif
}

RegisterCommands( )
{
    RegAdminCmd("sm_restrict", Command_Restrict, ADMFLAG_GENERIC, "sm_restrict <weapon> <team> <amt>");
    RegAdminCmd("sm_unrestrict", Command_Unrestrict, ADMFLAG_GENERIC, "sm_unrestrict <weapon> <team>");
    RegAdminCmd("sm_dropc4", Command_DropC4, ADMFLAG_GENERIC, "sm_dropc4");
    RegAdminCmd("sm_addgroup", Command_AddGroup, ADMFLAG_ROOT, "sm_addgroup <\"groupname\"> <\"weapon_one weapon_two weapon_three, etc\">");
    RegAdminCmd("sm_grouplist", Command_GroupList, ADMFLAG_ROOT, "sm_grouplist - Lists all weapon groups and their data.");
    RegConsoleCmd("buy", Command_Buy);
}

HookAllEvents( )
{
    HookEvent("weapon_fire", Event_WeaponFire);
    HookEvent("item_pickup", Event_ItemPickup);
#if WARMUP
    HookEvent("player_spawn", Event_PlayerSpawn);
#endif
}

RegisterADTData( )
{
    new f_WeaponSlots[MAX_WEAPONS] =
    {
        -1, -1, -1, -1, -1, -1,
        CS_SLOT_GRENADE, CS_SLOT_GRENADE, CS_SLOT_GRENADE, CS_SLOT_PRIMARY,
        CS_SLOT_PRIMARY, CS_SLOT_PRIMARY, CS_SLOT_PRIMARY, CS_SLOT_PRIMARY,
        CS_SLOT_PRIMARY, CS_SLOT_PRIMARY, CS_SLOT_PRIMARY, CS_SLOT_PRIMARY,
        CS_SLOT_PRIMARY, CS_SLOT_SECONDARY, CS_SLOT_SECONDARY, CS_SLOT_SECONDARY,
        CS_SLOT_SECONDARY, CS_SLOT_SECONDARY, CS_SLOT_SECONDARY, CS_SLOT_PRIMARY,
        CS_SLOT_PRIMARY, CS_SLOT_PRIMARY, CS_SLOT_PRIMARY, CS_SLOT_PRIMARY,
        CS_SLOT_PRIMARY, CS_SLOT_PRIMARY, CS_SLOT_PRIMARY, CS_SLOT_C4, CS_SLOT_KNIFE
    };

    new f_WeaponCosts[MAX_WEAPONS] =
    {
        0, 0, 0, 0, 0, 0, 200, 300, 300, 2000, 2500, 2750, 3500, 4750, 5000,
        2250, 3100, 3500, 4200, 400, 500, 600, 650, 800, 750, 1700, 3000, 1500, 
        1250, 1500, 1700, 2350, 5750, 0, 0
    };

    g_T_Restrictions = CreateTrie( );
    g_CT_Restrictions = CreateTrie( );
    g_WeaponSlots = CreateTrie( );
    g_WeaponCosts = CreateTrie( );

    // weapon groups
    g_GroupNames = CreateArray(32, 0);
    g_GroupWeapons = CreateTrie( );
    g_GroupLimits_CT = CreateTrie( );
    g_GroupLimits_T = CreateTrie( );

    for(new i = 0; i < MAX_WEAPONS; i++)
    {
        SetTrieValue(g_T_Restrictions, g_WeaponNames[i], -1);
        SetTrieValue(g_CT_Restrictions, g_WeaponNames[i], -1);
        SetTrieValue(g_WeaponSlots, g_WeaponNames[i], f_WeaponSlots[i]);
        SetTrieValue(g_WeaponCosts, g_WeaponNames[i], f_WeaponCosts[i]);
    }
}

RegisterOffsets( )
{
    // put in a check to error the plugin out if these fail
    g_iAccount = FindSendPropOffs("CCSPlayer", "m_iAccount");
    g_iOwner = FindSendPropOffs("CBaseCombatWeapon", "m_hOwnerEntity");
    if(g_iOwner == -1)
    {
        SetFailState("g_iOwner = -1");
    }
}

LoadHacks( )
{
    GameConf = LoadGameConfigFile("hacks.games");
    CreateDropHack( );
}
#if STOCK_MENUS
public OnAdminMenuReady(Handle:topmenu)
{
	/* Block us from being called twice */
	if (topmenu == hTopMenu)
	{
		return;
	}
	
	/* Save the Handle */
	hTopMenu = topmenu;
	
	/* Build the "Server Commands" category */
	new TopMenuObject:server_commands = FindTopMenuCategory(hTopMenu, ADMINMENU_SERVERCOMMANDS);

	if (server_commands != INVALID_TOPMENUOBJECT)
	{
		AddToTopMenu(hTopMenu,
			"sm_restrict",
			TopMenuObject_Item,
			AdminMenu_Restrict,
			server_commands,
			"sm_restrict",
			ADMFLAG_GENERIC);

		AddToTopMenu(hTopMenu,
			"sm_dropc4",
			TopMenuObject_Item,
			AdminMenu_DropC4,
			server_commands,
			"sm_dropc4",
			ADMFLAG_GENERIC);
	}
}

public OnLibraryRemoved(const String:name[])
{
	if (strcmp(name, "adminmenu") == 0)
	{
		hTopMenu = INVALID_HANDLE;
	}
}
#endif

