/**
 * vim: set ts=4 :
 * =============================================================================
 * Weapon Restriction w/ Warmup Plugin for SourceMod
 * Restricts weapons for Counter-Strike: Source.
 *
 * SourceMod (C)2004-2007 AlliedModders LLC.  All rights reserved.
 * =============================================================================
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 3.0, as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * As a special exception, AlliedModders LLC gives you permission to link the
 * code of this program (as well as its derivative works) to "Half-Life 2," the
 * "Source Engine," the "SourcePawn JIT," and any Game MODs that run on software
 * by the Valve Corporation.  You must obey the GNU General Public License in
 * all respects for all other code used.  Additionally, AlliedModders LLC grants
 * this exception to all derivative works.  AlliedModders LLC defines further
 * exceptions, found in LICENSE.txt (as of this writing, version JULY-31-2007),
 * or <http://www.sourcemod.net/license.php>.
 *
 */

#define MAX_CVARS 31

// cVars for CT weapon restrictions
new Handle:g_Cvar_Vest_CT = INVALID_HANDLE;
new Handle:g_Cvar_VestHelm_CT = INVALID_HANDLE;
new Handle:g_Cvar_Defuser_CT = INVALID_HANDLE;
new Handle:g_Cvar_Nvgs_CT = INVALID_HANDLE;
new Handle:g_Cvar_FlashBang_CT = INVALID_HANDLE;
new Handle:g_Cvar_HEGrenade_CT = INVALID_HANDLE;
new Handle:g_Cvar_SmokeGrenade_CT = INVALID_HANDLE;
new Handle:g_Cvar_Galil_CT = INVALID_HANDLE;
new Handle:g_Cvar_AK47_CT = INVALID_HANDLE;
new Handle:g_Cvar_Scout_CT = INVALID_HANDLE;
new Handle:g_Cvar_SG552_CT = INVALID_HANDLE;
new Handle:g_Cvar_AWP_CT = INVALID_HANDLE;
new Handle:g_Cvar_G3SG1_CT = INVALID_HANDLE;
new Handle:g_Cvar_Famas_CT = INVALID_HANDLE;
new Handle:g_Cvar_M4A1_CT = INVALID_HANDLE;
new Handle:g_Cvar_Aug_CT = INVALID_HANDLE;
new Handle:g_Cvar_SG550_CT = INVALID_HANDLE;
new Handle:g_Cvar_Glock_CT = INVALID_HANDLE;
new Handle:g_Cvar_USP_CT = INVALID_HANDLE;
new Handle:g_Cvar_P228_CT = INVALID_HANDLE;
new Handle:g_Cvar_Deagle_CT = INVALID_HANDLE;
new Handle:g_Cvar_Elite_CT = INVALID_HANDLE;
new Handle:g_Cvar_FiveSeven_CT = INVALID_HANDLE;
new Handle:g_Cvar_M3_CT = INVALID_HANDLE;
new Handle:g_Cvar_XM1014_CT = INVALID_HANDLE;
new Handle:g_Cvar_Mac10_CT = INVALID_HANDLE;
new Handle:g_Cvar_Tmp_CT = INVALID_HANDLE;
new Handle:g_Cvar_Mp5Navy_CT = INVALID_HANDLE;
new Handle:g_Cvar_Ump45_CT = INVALID_HANDLE;
new Handle:g_Cvar_P90_CT = INVALID_HANDLE;
new Handle:g_Cvar_M249_CT = INVALID_HANDLE;

// cVars for T weapon restrictions
new Handle:g_Cvar_Vest_T = INVALID_HANDLE;
new Handle:g_Cvar_VestHelm_T = INVALID_HANDLE;
new Handle:g_Cvar_Defuser_T = INVALID_HANDLE;
new Handle:g_Cvar_Nvgs_T = INVALID_HANDLE;
new Handle:g_Cvar_FlashBang_T = INVALID_HANDLE;
new Handle:g_Cvar_HEGrenade_T = INVALID_HANDLE;
new Handle:g_Cvar_SmokeGrenade_T = INVALID_HANDLE;
new Handle:g_Cvar_Galil_T = INVALID_HANDLE;
new Handle:g_Cvar_AK47_T = INVALID_HANDLE;
new Handle:g_Cvar_Scout_T = INVALID_HANDLE;
new Handle:g_Cvar_SG552_T = INVALID_HANDLE;
new Handle:g_Cvar_AWP_T = INVALID_HANDLE;
new Handle:g_Cvar_G3SG1_T = INVALID_HANDLE;
new Handle:g_Cvar_Famas_T = INVALID_HANDLE;
new Handle:g_Cvar_M4A1_T = INVALID_HANDLE;
new Handle:g_Cvar_Aug_T = INVALID_HANDLE;
new Handle:g_Cvar_SG550_T = INVALID_HANDLE;
new Handle:g_Cvar_Glock_T = INVALID_HANDLE;
new Handle:g_Cvar_USP_T = INVALID_HANDLE;
new Handle:g_Cvar_P228_T = INVALID_HANDLE;
new Handle:g_Cvar_Deagle_T = INVALID_HANDLE;
new Handle:g_Cvar_Elite_T = INVALID_HANDLE;
new Handle:g_Cvar_FiveSeven_T = INVALID_HANDLE;
new Handle:g_Cvar_M3_T = INVALID_HANDLE;
new Handle:g_Cvar_XM1014_T = INVALID_HANDLE;
new Handle:g_Cvar_Mac10_T = INVALID_HANDLE;
new Handle:g_Cvar_Tmp_T = INVALID_HANDLE;
new Handle:g_Cvar_Mp5Navy_T = INVALID_HANDLE;
new Handle:g_Cvar_Ump45_T = INVALID_HANDLE;
new Handle:g_Cvar_P90_T = INVALID_HANDLE;
new Handle:g_Cvar_M249_T = INVALID_HANDLE;

RegisterConVars( )
{
    CreateConVar("weapon_restriction_version", VERSION, 
        "Current version of Weapon Restrictions", FCVAR_REPLICATED|FCVAR_NOTIFY|FCVAR_DONTRECORD);

#if WARMUP
    g_Cvar_Warmup = CreateConVar("sm_warmup_running", "0", "Whether or not the warmup is running or not.", FCVAR_DONTRECORD);
    g_Cvar_Warmup_System = CreateConVar("sm_warmup_system", "1", "Warmup System: 1 = On, 0 = Off");
    g_Cvar_Warmup_Time = CreateConVar("sm_warmup_time", "60", "Amount of time in seconds that Warmup runs");
#endif

    // CT Cvars
    g_Cvar_Vest_CT = CreateConVar("sm_restrict_vest_ct", "-1", "Vest Armor Restriction for CT");
    g_Cvar_VestHelm_CT = CreateConVar("sm_restrict_vesthelm_ct", "-1", "Vest-Helm Armor Restriction for CT");
    g_Cvar_Defuser_CT = CreateConVar("sm_restrict_defuser_ct", "-1", "Defuser Restriction for CT");
    g_Cvar_Nvgs_CT = CreateConVar("sm_restrict_nvgs_ct", "-1", "Night-Vision Goggles Restriction for CT");
    g_Cvar_FlashBang_CT = CreateConVar("sm_restrict_flashbang_ct", "-1", "Flashbang Restriction for CT");
    g_Cvar_HEGrenade_CT = CreateConVar("sm_restrict_hegrenade_ct", "-1", "High-Explosive Grenade Restriction for CT");
    g_Cvar_SmokeGrenade_CT = CreateConVar("sm_restrict_smokegrenade_ct", "-1", "Smoke Grenade Restriction for CT");
    g_Cvar_Galil_CT = CreateConVar("sm_restrict_galil_ct", "-1", "Galil Restriction for CT");
    g_Cvar_AK47_CT = CreateConVar("sm_restrict_ak47_ct", "-1", "AK47 Restriction for CT");
    g_Cvar_Scout_CT = CreateConVar("sm_restrict_scout_ct", "-1", "Scout Restriction for CT");
    g_Cvar_SG552_CT = CreateConVar("sm_restrict_sg552_ct", "-1", "SG552 Restriction for CT");
    g_Cvar_AWP_CT = CreateConVar("sm_restrict_awp_ct", "-1", "AWP Restriction for CT");
    g_Cvar_G3SG1_CT = CreateConVar("sm_restrict_g3sg1_ct", "-1", "G3SG1 Restriction for CT");
    g_Cvar_Famas_CT = CreateConVar("sm_restrict_famas_ct", "-1", "Famas Restriction for CT");
    g_Cvar_M4A1_CT = CreateConVar("sm_restrict_m4a1_ct", "-1", "M4A1 Restriction for CT");
    g_Cvar_Aug_CT = CreateConVar("sm_restrict_aug_ct", "-1", "Aug Restriction for CT");
    g_Cvar_SG550_CT = CreateConVar("sm_restrict_sg550_ct", "-1", "SG550 Restriction for CT");
    g_Cvar_Glock_CT = CreateConVar("sm_restrict_glock_ct", "-1", "Glock Restriction for CT");
    g_Cvar_USP_CT = CreateConVar("sm_restrict_usp_ct", "-1", "USP Restriction for CT");
    g_Cvar_P228_CT = CreateConVar("sm_restrict_p228_ct", "-1", "P228 Restriction for CT");
    g_Cvar_Deagle_CT = CreateConVar("sm_restrict_deagle_ct", "-1", "Deagle Restriction for CT");
    g_Cvar_Elite_CT = CreateConVar("sm_restrict_elite_ct", "-1", "Elite Restriction for CT");
    g_Cvar_FiveSeven_CT = CreateConVar("sm_restrict_fiveseven_ct", "-1", "Five-Seven Restriction for CT");
    g_Cvar_M3_CT = CreateConVar("sm_restrict_m3_ct", "-1", "M3 Restriction for CT");
    g_Cvar_XM1014_CT = CreateConVar("sm_restrict_xm1014_ct", "-1", "XM1014 Restriction for CT");
    g_Cvar_Mac10_CT = CreateConVar("sm_restrict_mac10_ct", "-1", "Mac10 Restriction for CT");
    g_Cvar_Tmp_CT = CreateConVar("sm_restrict_tmp_ct", "-1", "TMP Restriction for CT");
    g_Cvar_Mp5Navy_CT = CreateConVar("sm_restrict_mp5navy_ct", "-1", "MP5 Navy Restriction for CT");
    g_Cvar_Ump45_CT = CreateConVar("sm_restrict_ump45_ct", "-1", "UMP45 Restriction for CT");
    g_Cvar_P90_CT = CreateConVar("sm_restrict_p90_ct", "-1", "P90 Restriction for CT");
    g_Cvar_M249_CT = CreateConVar("sm_restrict_m249_ct", "-1", "M249 Restriction for CT");

    // T Cvars
    g_Cvar_Vest_T = CreateConVar("sm_restrict_vest_t", "-1", "Vest Armor Restriction for T");
    g_Cvar_VestHelm_T = CreateConVar("sm_restrict_vesthelm_t", "-1", "Vest-Helm Armor Restriction for T");
    g_Cvar_Defuser_T = CreateConVar("sm_restrict_defuser_t", "-1", "Defuser Restriction for T");
    g_Cvar_Nvgs_T = CreateConVar("sm_restrict_nvgs_t", "-1", "Night-Vision Goggles Restriction for T");
    g_Cvar_FlashBang_T = CreateConVar("sm_restrict_flashbang_t", "-1", "Flashbang Restriction for T");
    g_Cvar_HEGrenade_T = CreateConVar("sm_restrict_hegrenade_t", "-1", "High-Explosive Grenade Restriction for T");
    g_Cvar_SmokeGrenade_T = CreateConVar("sm_restrict_smokegrenade_t", "-1", "Smoke Grenade Restriction for T");
    g_Cvar_Galil_T = CreateConVar("sm_restrict_galil_t", "-1", "Galil Restriction for T");
    g_Cvar_AK47_T = CreateConVar("sm_restrict_ak47_t", "-1", "AK47 Restriction for T");
    g_Cvar_Scout_T = CreateConVar("sm_restrict_scout_t", "-1", "Scout Restriction for T");
    g_Cvar_SG552_T = CreateConVar("sm_restrict_sg552_t", "-1", "SG552 Restriction for T");
    g_Cvar_AWP_T = CreateConVar("sm_restrict_awp_t", "-1", "AWP Restriction for T");
    g_Cvar_G3SG1_T = CreateConVar("sm_restrict_g3sg1_t", "-1", "G3SG1 Restriction for T");
    g_Cvar_Famas_T = CreateConVar("sm_restrict_famas_t", "-1", "Famas Restriction for T");
    g_Cvar_M4A1_T = CreateConVar("sm_restrict_m4a1_t", "-1", "M4A1 Restriction for T");
    g_Cvar_Aug_T = CreateConVar("sm_restrict_aug_t", "-1", "Aug Restriction for T");
    g_Cvar_SG550_T = CreateConVar("sm_restrict_sg550_t", "-1", "SG550 Restriction for T");
    g_Cvar_Glock_T = CreateConVar("sm_restrict_glock_t", "-1", "Glock Restriction for T");
    g_Cvar_USP_T = CreateConVar("sm_restrict_usp_t", "-1", "USP Restriction for T");
    g_Cvar_P228_T = CreateConVar("sm_restrict_p228_t", "-1", "P228 Restriction for T");
    g_Cvar_Deagle_T = CreateConVar("sm_restrict_deagle_t", "-1", "Deagle Restriction for T");
    g_Cvar_Elite_T = CreateConVar("sm_restrict_elite_t", "-1", "Elite Restriction for T");
    g_Cvar_FiveSeven_T = CreateConVar("sm_restrict_fiveseven_t", "-1", "Five-Seven Restriction for T");
    g_Cvar_M3_T = CreateConVar("sm_restrict_m3_t", "-1", "M3 Restriction for T");
    g_Cvar_XM1014_T = CreateConVar("sm_restrict_xm1014_t", "-1", "XM1014 Restriction for T");
    g_Cvar_Mac10_T = CreateConVar("sm_restrict_mac10_t", "-1", "Mac10 Restriction for T");
    g_Cvar_Tmp_T = CreateConVar("sm_restrict_tmp_t", "-1", "TMP Restriction for T");
    g_Cvar_Mp5Navy_T = CreateConVar("sm_restrict_mp5navy_t", "-1", "MP5 Navy Restriction for T");
    g_Cvar_Ump45_T = CreateConVar("sm_restrict_ump45_t", "-1", "UMP45 Restriction for T");
    g_Cvar_P90_T = CreateConVar("sm_restrict_p90_t", "-1", "P90 Restriction for T");
    g_Cvar_M249_T = CreateConVar("sm_restrict_m249_t", "-1", "M249 Restriction for T");
}

HookConVars( )
{
    HookConVarChange(g_Cvar_Vest_CT, ConVar_Vest_CT);
    HookConVarChange(g_Cvar_VestHelm_CT, ConVar_VestHelm_CT);
    HookConVarChange(g_Cvar_Defuser_CT, ConVar_Defuser_CT);
    HookConVarChange(g_Cvar_Nvgs_CT, ConVar_Nvgs_CT);
    HookConVarChange(g_Cvar_FlashBang_CT, ConVar_FlashBang_CT);
    HookConVarChange(g_Cvar_HEGrenade_CT, ConVar_HEGrenade_CT);
    HookConVarChange(g_Cvar_SmokeGrenade_CT, ConVar_SmokeGrenade_CT);
    HookConVarChange(g_Cvar_Galil_CT, ConVar_Galil_CT);
    HookConVarChange(g_Cvar_AK47_CT, ConVar_AK47_CT);
    HookConVarChange(g_Cvar_Scout_CT, ConVar_Scout_CT);
    HookConVarChange(g_Cvar_SG552_CT, ConVar_SG552_CT);
    HookConVarChange(g_Cvar_AWP_CT, ConVar_AWP_CT);
    HookConVarChange(g_Cvar_G3SG1_CT, ConVar_G3SG1_CT);
    HookConVarChange(g_Cvar_Famas_CT, ConVar_Famas_CT);
    HookConVarChange(g_Cvar_M4A1_CT, ConVar_M4A1_CT);
    HookConVarChange(g_Cvar_Aug_CT, ConVar_Aug_CT);
    HookConVarChange(g_Cvar_SG550_CT, ConVar_SG550_CT);
    HookConVarChange(g_Cvar_Glock_CT, ConVar_Glock_CT);
    HookConVarChange(g_Cvar_USP_CT, ConVar_USP_CT);
    HookConVarChange(g_Cvar_P228_CT, ConVar_P228_CT);
    HookConVarChange(g_Cvar_Deagle_CT, ConVar_Deagle_CT);
    HookConVarChange(g_Cvar_Elite_CT, ConVar_Elite_CT);
    HookConVarChange(g_Cvar_FiveSeven_CT, ConVar_FiveSeven_CT);
    HookConVarChange(g_Cvar_M3_CT, ConVar_M3_CT);
    HookConVarChange(g_Cvar_XM1014_CT, ConVar_XM1014_CT);
    HookConVarChange(g_Cvar_Mac10_CT, ConVar_Mac10_CT);
    HookConVarChange(g_Cvar_Tmp_CT, ConVar_Tmp_CT);
    HookConVarChange(g_Cvar_Mp5Navy_CT, ConVar_Mp5Navy_CT);
    HookConVarChange(g_Cvar_Ump45_CT, ConVar_Ump45_CT);
    HookConVarChange(g_Cvar_P90_CT, ConVar_P90_CT);
    HookConVarChange(g_Cvar_M249_CT, ConVar_M249_CT);

    HookConVarChange(g_Cvar_Vest_T, ConVar_Vest_T);
    HookConVarChange(g_Cvar_VestHelm_T, ConVar_VestHelm_T);
    HookConVarChange(g_Cvar_Defuser_T, ConVar_Defuser_T);
    HookConVarChange(g_Cvar_Nvgs_T, ConVar_Nvgs_T);
    HookConVarChange(g_Cvar_FlashBang_T, ConVar_FlashBang_T);
    HookConVarChange(g_Cvar_HEGrenade_T, ConVar_HEGrenade_T);
    HookConVarChange(g_Cvar_SmokeGrenade_T, ConVar_SmokeGrenade_T);
    HookConVarChange(g_Cvar_Galil_T, ConVar_Galil_T);
    HookConVarChange(g_Cvar_AK47_T, ConVar_AK47_T);
    HookConVarChange(g_Cvar_Scout_T, ConVar_Scout_T);
    HookConVarChange(g_Cvar_SG552_T, ConVar_SG552_T);
    HookConVarChange(g_Cvar_AWP_T, ConVar_AWP_T);
    HookConVarChange(g_Cvar_G3SG1_T, ConVar_G3SG1_T);
    HookConVarChange(g_Cvar_Famas_T, ConVar_Famas_T);
    HookConVarChange(g_Cvar_M4A1_T, ConVar_M4A1_T);
    HookConVarChange(g_Cvar_Aug_T, ConVar_Aug_T);
    HookConVarChange(g_Cvar_SG550_T, ConVar_SG550_T);
    HookConVarChange(g_Cvar_Glock_T, ConVar_Glock_T);
    HookConVarChange(g_Cvar_USP_T, ConVar_USP_T);
    HookConVarChange(g_Cvar_P228_T, ConVar_P228_T);
    HookConVarChange(g_Cvar_Deagle_T, ConVar_Deagle_T);
    HookConVarChange(g_Cvar_Elite_T, ConVar_Elite_T);
    HookConVarChange(g_Cvar_FiveSeven_T, ConVar_FiveSeven_T);
    HookConVarChange(g_Cvar_M3_T, ConVar_M3_T);
    HookConVarChange(g_Cvar_XM1014_T, ConVar_XM1014_T);
    HookConVarChange(g_Cvar_Mac10_T, ConVar_Mac10_T);
    HookConVarChange(g_Cvar_Tmp_T, ConVar_Tmp_T);
    HookConVarChange(g_Cvar_Mp5Navy_T, ConVar_Mp5Navy_T);
    HookConVarChange(g_Cvar_Ump45_T, ConVar_Ump45_T);
    HookConVarChange(g_Cvar_P90_T, ConVar_P90_T);
    HookConVarChange(g_Cvar_M249_T, ConVar_M249_T);
}

UnHookConVars( )
{
    UnhookConVarChange(g_Cvar_Vest_CT, ConVar_Vest_CT);
    UnhookConVarChange(g_Cvar_VestHelm_CT, ConVar_VestHelm_CT);
    UnhookConVarChange(g_Cvar_Defuser_CT, ConVar_Defuser_CT);
    UnhookConVarChange(g_Cvar_Nvgs_CT, ConVar_Nvgs_CT);
    UnhookConVarChange(g_Cvar_FlashBang_CT, ConVar_FlashBang_CT);
    UnhookConVarChange(g_Cvar_HEGrenade_CT, ConVar_HEGrenade_CT);
    UnhookConVarChange(g_Cvar_SmokeGrenade_CT, ConVar_SmokeGrenade_CT);
    UnhookConVarChange(g_Cvar_Galil_CT, ConVar_Galil_CT);
    UnhookConVarChange(g_Cvar_AK47_CT, ConVar_AK47_CT);
    UnhookConVarChange(g_Cvar_Scout_CT, ConVar_Scout_CT);
    UnhookConVarChange(g_Cvar_SG552_CT, ConVar_SG552_CT);
    UnhookConVarChange(g_Cvar_AWP_CT, ConVar_AWP_CT);
    UnhookConVarChange(g_Cvar_G3SG1_CT, ConVar_G3SG1_CT);
    UnhookConVarChange(g_Cvar_Famas_CT, ConVar_Famas_CT);
    UnhookConVarChange(g_Cvar_M4A1_CT, ConVar_M4A1_CT);
    UnhookConVarChange(g_Cvar_Aug_CT, ConVar_Aug_CT);
    UnhookConVarChange(g_Cvar_SG550_CT, ConVar_SG550_CT);
    UnhookConVarChange(g_Cvar_Glock_CT, ConVar_Glock_CT);
    UnhookConVarChange(g_Cvar_USP_CT, ConVar_USP_CT);
    UnhookConVarChange(g_Cvar_P228_CT, ConVar_P228_CT);
    UnhookConVarChange(g_Cvar_Deagle_CT, ConVar_Deagle_CT);
    UnhookConVarChange(g_Cvar_Elite_CT, ConVar_Elite_CT);
    UnhookConVarChange(g_Cvar_FiveSeven_CT, ConVar_FiveSeven_CT);
    UnhookConVarChange(g_Cvar_M3_CT, ConVar_M3_CT);
    UnhookConVarChange(g_Cvar_XM1014_CT, ConVar_XM1014_CT);
    UnhookConVarChange(g_Cvar_Mac10_CT, ConVar_Mac10_CT);
    UnhookConVarChange(g_Cvar_Tmp_CT, ConVar_Tmp_CT);
    UnhookConVarChange(g_Cvar_Mp5Navy_CT, ConVar_Mp5Navy_CT);
    UnhookConVarChange(g_Cvar_Ump45_CT, ConVar_Ump45_CT);
    UnhookConVarChange(g_Cvar_P90_CT, ConVar_P90_CT);
    UnhookConVarChange(g_Cvar_M249_CT, ConVar_M249_CT);

    UnhookConVarChange(g_Cvar_Vest_T, ConVar_Vest_T);
    UnhookConVarChange(g_Cvar_VestHelm_T, ConVar_VestHelm_T);
    UnhookConVarChange(g_Cvar_Defuser_T, ConVar_Defuser_T);
    UnhookConVarChange(g_Cvar_Nvgs_T, ConVar_Nvgs_T);
    UnhookConVarChange(g_Cvar_FlashBang_T, ConVar_FlashBang_T);
    UnhookConVarChange(g_Cvar_HEGrenade_T, ConVar_HEGrenade_T);
    UnhookConVarChange(g_Cvar_SmokeGrenade_T, ConVar_SmokeGrenade_T);
    UnhookConVarChange(g_Cvar_Galil_T, ConVar_Galil_T);
    UnhookConVarChange(g_Cvar_AK47_T, ConVar_AK47_T);
    UnhookConVarChange(g_Cvar_Scout_T, ConVar_Scout_T);
    UnhookConVarChange(g_Cvar_SG552_T, ConVar_SG552_T);
    UnhookConVarChange(g_Cvar_AWP_T, ConVar_AWP_T);
    UnhookConVarChange(g_Cvar_G3SG1_T, ConVar_G3SG1_T);
    UnhookConVarChange(g_Cvar_Famas_T, ConVar_Famas_T);
    UnhookConVarChange(g_Cvar_M4A1_T, ConVar_M4A1_T);
    UnhookConVarChange(g_Cvar_Aug_T, ConVar_Aug_T);
    UnhookConVarChange(g_Cvar_SG550_T, ConVar_SG550_T);
    UnhookConVarChange(g_Cvar_Glock_T, ConVar_Glock_T);
    UnhookConVarChange(g_Cvar_USP_T, ConVar_USP_T);
    UnhookConVarChange(g_Cvar_P228_T, ConVar_P228_T);
    UnhookConVarChange(g_Cvar_Deagle_T, ConVar_Deagle_T);
    UnhookConVarChange(g_Cvar_Elite_T, ConVar_Elite_T);
    UnhookConVarChange(g_Cvar_FiveSeven_T, ConVar_FiveSeven_T);
    UnhookConVarChange(g_Cvar_M3_T, ConVar_M3_T);
    UnhookConVarChange(g_Cvar_XM1014_T, ConVar_XM1014_T);
    UnhookConVarChange(g_Cvar_Mac10_T, ConVar_Mac10_T);
    UnhookConVarChange(g_Cvar_Tmp_T, ConVar_Tmp_T);
    UnhookConVarChange(g_Cvar_Mp5Navy_T, ConVar_Mp5Navy_T);
    UnhookConVarChange(g_Cvar_Ump45_T, ConVar_Ump45_T);
    UnhookConVarChange(g_Cvar_P90_T, ConVar_P90_T);
    UnhookConVarChange(g_Cvar_M249_T, ConVar_M249_T);
}

ResetConVars( )
{
    UnHookConVars( );

    ResetConVar(g_Cvar_Vest_CT);
    ResetConVar(g_Cvar_VestHelm_CT);
    ResetConVar(g_Cvar_Defuser_CT);
    ResetConVar(g_Cvar_Nvgs_CT);
    ResetConVar(g_Cvar_FlashBang_CT);
    ResetConVar(g_Cvar_HEGrenade_CT);
    ResetConVar(g_Cvar_SmokeGrenade_CT);
    ResetConVar(g_Cvar_Galil_CT);
    ResetConVar(g_Cvar_AK47_CT);
    ResetConVar(g_Cvar_Scout_CT);
    ResetConVar(g_Cvar_SG552_CT);
    ResetConVar(g_Cvar_AWP_CT);
    ResetConVar(g_Cvar_G3SG1_CT);
    ResetConVar(g_Cvar_Famas_CT);
    ResetConVar(g_Cvar_M4A1_CT);
    ResetConVar(g_Cvar_Aug_CT);
    ResetConVar(g_Cvar_SG550_CT);
    ResetConVar(g_Cvar_Glock_CT);
    ResetConVar(g_Cvar_USP_CT);
    ResetConVar(g_Cvar_P228_CT);
    ResetConVar(g_Cvar_Deagle_CT);
    ResetConVar(g_Cvar_Elite_CT);
    ResetConVar(g_Cvar_FiveSeven_CT);
    ResetConVar(g_Cvar_M3_CT);
    ResetConVar(g_Cvar_XM1014_CT);
    ResetConVar(g_Cvar_Mac10_CT);
    ResetConVar(g_Cvar_Tmp_CT);
    ResetConVar(g_Cvar_Mp5Navy_CT);
    ResetConVar(g_Cvar_Ump45_CT);
    ResetConVar(g_Cvar_P90_CT);
    ResetConVar(g_Cvar_M249_CT);

    ResetConVar(g_Cvar_Vest_T);
    ResetConVar(g_Cvar_VestHelm_T);
    ResetConVar(g_Cvar_Defuser_T);
    ResetConVar(g_Cvar_Nvgs_T);
    ResetConVar(g_Cvar_FlashBang_T);
    ResetConVar(g_Cvar_HEGrenade_T);
    ResetConVar(g_Cvar_SmokeGrenade_T);
    ResetConVar(g_Cvar_Galil_T);
    ResetConVar(g_Cvar_AK47_T);
    ResetConVar(g_Cvar_Scout_T);
    ResetConVar(g_Cvar_SG552_T);
    ResetConVar(g_Cvar_AWP_T);
    ResetConVar(g_Cvar_G3SG1_T);
    ResetConVar(g_Cvar_Famas_T);
    ResetConVar(g_Cvar_M4A1_T);
    ResetConVar(g_Cvar_Aug_T);
    ResetConVar(g_Cvar_SG550_T);
    ResetConVar(g_Cvar_Glock_T);
    ResetConVar(g_Cvar_USP_T);
    ResetConVar(g_Cvar_P228_T);
    ResetConVar(g_Cvar_Deagle_T);
    ResetConVar(g_Cvar_Elite_T);
    ResetConVar(g_Cvar_FiveSeven_T);
    ResetConVar(g_Cvar_M3_T);
    ResetConVar(g_Cvar_XM1014_T);
    ResetConVar(g_Cvar_Mac10_T);
    ResetConVar(g_Cvar_Tmp_T);
    ResetConVar(g_Cvar_Mp5Navy_T);
    ResetConVar(g_Cvar_Ump45_T);
    ResetConVar(g_Cvar_P90_T);
    ResetConVar(g_Cvar_M249_T);

    HookConVars( );
}

HandleWeaponCvar(String:weapon[], String:value[], String:team[])
{
    if(StringToInt(value) == -1)
        UnrestrictWeapon(0, weapon, team);
    else
        RestrictWeapon(0, weapon, StringToInt(value), team);
}

public ConVar_Vest_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("vest", f_Value, "ct");

}

public ConVar_VestHelm_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("vesthelm", f_Value, "ct");
}

public ConVar_Defuser_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("defuser", f_Value, "ct");
}

public ConVar_Nvgs_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("nvgs", f_Value, "ct");
}

public ConVar_FlashBang_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("flashbang", f_Value, "ct");
}

public ConVar_HEGrenade_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("hegrenade", f_Value, "ct");
}

public ConVar_SmokeGrenade_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("smokegrenade", f_Value, "ct");
}

public ConVar_Galil_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("galil", f_Value, "ct");
}

public ConVar_AK47_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("ak47", f_Value, "ct");
}

public ConVar_Scout_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("scout", f_Value, "ct");
}

public ConVar_SG552_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("sg552", f_Value, "ct");
}

public ConVar_AWP_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("awp", f_Value, "ct");
}

public ConVar_G3SG1_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("g3sg1", f_Value, "ct");
}

public ConVar_Famas_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("famas", f_Value, "ct");
}

public ConVar_M4A1_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("m4a1", f_Value, "ct");
}

public ConVar_Aug_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("aug", f_Value, "ct");
}

public ConVar_SG550_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("sg550", f_Value, "ct");
}

public ConVar_Glock_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("glock", f_Value, "ct");
}

public ConVar_USP_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("usp", f_Value, "ct");
}

public ConVar_P228_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("p228", f_Value, "ct");
}

public ConVar_Deagle_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("deagle", f_Value, "ct");
}

public ConVar_Elite_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("elite", f_Value, "ct");
}

public ConVar_FiveSeven_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("fiveseven", f_Value, "ct");
}

public ConVar_M3_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("m3", f_Value, "ct");
}

public ConVar_XM1014_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("xm1014", f_Value, "ct");
}

public ConVar_Mac10_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("mac10", f_Value, "ct");
}

public ConVar_Tmp_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("tmp", f_Value, "ct");
}

public ConVar_Mp5Navy_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("mp5navy", f_Value, "ct");
}

public ConVar_Ump45_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("ump45", f_Value, "ct");
}

public ConVar_P90_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("p90", f_Value, "ct");
}

public ConVar_M249_CT(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("m249", f_Value, "ct");
}

public ConVar_Vest_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("vest", f_Value, "t");
}

public ConVar_VestHelm_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("vesthelm", f_Value, "t");
}

public ConVar_Defuser_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("defuser", f_Value, "t");
}

public ConVar_Nvgs_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("nvgs", f_Value, "t");
}

public ConVar_FlashBang_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("flashbang", f_Value, "t");
}

public ConVar_HEGrenade_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("hegrenade", f_Value, "t");
}

public ConVar_SmokeGrenade_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("smokegrenade", f_Value, "t");
}

public ConVar_Galil_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("galil", f_Value, "t");
}

public ConVar_AK47_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("ak47", f_Value, "t");
}

public ConVar_Scout_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("scout", f_Value, "t");
}

public ConVar_SG552_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("sg552", f_Value, "t");
}

public ConVar_AWP_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("awp", f_Value, "t");
}

public ConVar_G3SG1_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("g3sg1", f_Value, "t");
}

public ConVar_Famas_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("famas", f_Value, "t");
}

public ConVar_M4A1_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("m4a1", f_Value, "t");
}

public ConVar_Aug_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("aug", f_Value, "t");
}

public ConVar_SG550_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("sg550", f_Value, "t");
}

public ConVar_Glock_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("glock", f_Value, "t");
}

public ConVar_USP_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("usp", f_Value, "t");
}

public ConVar_P228_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("p228", f_Value, "t");
}

public ConVar_Deagle_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("deagle", f_Value, "t");
}

public ConVar_Elite_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("elite", f_Value, "t");
}

public ConVar_FiveSeven_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("fiveseven", f_Value, "t");
}

public ConVar_M3_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("m3", f_Value, "t");
}

public ConVar_XM1014_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("xm1014", f_Value, "t");
}

public ConVar_Mac10_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("mac10", f_Value, "t");
}

public ConVar_Tmp_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("tmp", f_Value, "t");
}

public ConVar_Mp5Navy_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("mp5navy", f_Value, "t");
}

public ConVar_Ump45_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("ump45", f_Value, "t");
}

public ConVar_P90_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("p90", f_Value, "t");
}

public ConVar_M249_T(Handle:cvar, const String:oldVal[], const String:newVal[])
{
    decl String:f_Value[10];
    GetConVarString(cvar, f_Value, sizeof(f_Value));

    HandleWeaponCvar("m249", f_Value, "t");
}