/**
 * vim: set ts=4 :
 * =============================================================================
 * Weapon Restriction w/ Warmup Plugin for SourceMod
 * Restricts weapons for Counter-Strike: Source.
 *
 * SourceMod (C)2004-2007 AlliedModders LLC.  All rights reserved.
 * =============================================================================
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 3.0, as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * As a special exception, AlliedModders LLC gives you permission to link the
 * code of this program (as well as its derivative works) to "Half-Life 2," the
 * "Source Engine," the "SourcePawn JIT," and any Game MODs that run on software
 * by the Valve Corporation.  You must obey the GNU General Public License in
 * all respects for all other code used.  Additionally, AlliedModders LLC grants
 * this exception to all derivative works.  AlliedModders LLC defines further
 * exceptions, found in LICENSE.txt (as of this writing, version JULY-31-2007),
 * or <http://www.sourcemod.net/license.php>.
 *
 */

public Action:Command_AddGroup(client, args)
{
    if(args < 2)
    {
        ReplyToCommand(client, "Usage: sm_addgroup <\"group name\"> <\"weapon_one weapon_two weapon_three etc\">");
        return Plugin_Handled;
    }

    decl String:f_GroupName[32], String:f_WeaponString[512], String:f_Amount[32];
    decl String:f_FormattedWeaponsString[512];
    GetCmdArg(1, f_GroupName, sizeof(f_GroupName));
    GetCmdArg(2, f_WeaponString, sizeof(f_WeaponString));
    GetCmdArg(3, f_Amount, sizeof(f_Amount));

    if(f_Amount[0] == '\0')
        f_Amount = "-1";

    FormatGroupWeaponString(f_WeaponString, f_FormattedWeaponsString, sizeof(f_FormattedWeaponsString));

    if(FindStringInArray(g_GroupNames, f_GroupName) == -1)
        PushArrayString(g_GroupNames, f_GroupName);
    SetTrieString(g_GroupWeapons, f_GroupName, f_WeaponString);
    ReplyToCommand(client, "%s - %s", f_GroupName, f_WeaponString);
    return Plugin_Handled;
}

public Action:Command_GroupList(client, args)
{
    new size = GetArraySize(g_GroupNames);

    if(size == 0)
    {
        ReplyToCommand(client, "There aren't any groups currently setup.");
        return Plugin_Handled;
    }

    ReplyToCommand(client, "%-32s %-50s", "Group Name", "Weapons");
    ReplyToCommand(client, "-----------------------------------------------------------------------------------");

    decl String:name[64], String:weapons[512];

    for(new i = 0; i < size; i++)
    {
        GetArrayString(g_GroupNames, i, name, sizeof(name));
        GetTrieString(g_GroupWeapons, name, weapons, sizeof(weapons));

        ReplyToCommand(client, "%32s %50s", name, weapons);
    }
    return Plugin_Handled;
}

bool:IsWeaponGroup(String:group[])
{
    return (FindStringInArray(g_GroupNames, group) == -1 ? false : true);
}

FindGroupLimit(String:weapon[], team)
{
    new limit, index = -1, len = GetArraySize(g_GroupNames);
    decl String:group[32];

    for(new i = 0; i < len; i++)
    {
        GetArrayString(g_GroupNames, i, group, sizeof(group));
        if(IsWeaponInGroup(group, weapon))
        {
            index = i;
            break;
        }
    }

    if(index == -1)
        return -1;

    switch(team)
    {
        case CS_TEAM_CT:
        {
            if(!GetTrieValue(g_GroupLimits_CT, group, limit))
                limit = -1;
        }

        case CS_TEAM_T:
        {
            if(!GetTrieValue(g_GroupLimits_T, group, limit))
                limit = -1;
        }
    }
    return limit;
}


RestrictWeaponsGroup(client, String:group[], amount, String:team[])
{
    switch(team[0])
    {
        case '\0', 'a', 'A':
        {
            SetTrieValue(g_GroupLimits_CT, group, amount);
            SetTrieValue(g_GroupLimits_T, group, amount);
        }

        case 'c', 'C':
        {
            SetTrieValue(g_GroupLimits_CT, group, amount);
        }

        case 't', 'T':
        {
            SetTrieValue(g_GroupLimits_T, group, amount);
        }
    }
    if(client > 0)
    {
        ShowActivity2(client, "[SM] ", "%t", "Restricted Weapon Group", client, group);
        LogAction(client, -1, "\"%L\" restricted group %s to %d for %s.", client, group, amount, team);
    }
    RemoveWeaponsInGroup(group);
}

UnrestrictWeaponsGroup(client, String:group[], String:team[])
{
    switch(team[0])
    {
        case '\0', 'a', 'A':
        {
            RemoveFromTrie(g_GroupLimits_CT, group);
            RemoveFromTrie(g_GroupLimits_T, group);
        }

        case 'c', 'C':
        {
            RemoveFromTrie(g_GroupLimits_CT, group);
        }

        case 't', 'T':
        {
            RemoveFromTrie(g_GroupLimits_T, group);
        }
    }
    if(client > 0)
	{
		ShowActivity2(client, "[SM] ", "%t", "Unrestricted Weapon Group", client, group);
		LogAction(client, -1, "\"%L\" unrestricted %s for %s.", client, group, team);
	}
}

bool:IsWeaponInGroup(String:group[], String:weapon[])
{
    decl String:weaponsList[512], String:arg[64];
    GetTrieString(g_GroupWeapons, group, weaponsList, sizeof(weaponsList));
    new loc, len = strlen(weaponsList);

    for(new i = 0; i < len; i++)
    {
        if(weaponsList[i] == ' ' && strlen(arg) > 0)
        {
            arg[loc] = '\0';
            if(strncmp(arg, weapon, strlen(weapon), false) == 0)
            {
                return true;
            }
            loc = 0;
        }
        else
        {
            arg[loc] = weaponsList[i];
            loc++;
        }
    }
    return false;
}

FormatGroupWeaponString(String:list[], String:newList[], newLen)
{
    decl String:arg[64], String:weapon[64];
    new loc, len = strlen(list);

    for(new i = 0; i < len; i++)
    {
        if(list[i] == ' ' && strlen(arg) > 0)
        {
            arg[loc] = '\0';
            FormatWeaponName(arg, weapon, sizeof(weapon));
            StrCat(newList, newLen, weapon);
            loc = 0;
        }
        else
        {
            arg[loc] = list[i];
            loc++;
        }
    }
    newList[strlen(newList)-1] = '\0';
}

RemoveWeaponsInGroup(String:group[])
{
    decl String:weaponsList[512], String:arg[64];
    GetTrieString(g_GroupWeapons, group, weaponsList, sizeof(weaponsList));
    new loc, len = strlen(weaponsList);

    for(new i = 0; i < len; i++)
    {
        if(weaponsList[i] == ' ' && strlen(arg) > 0)
        {
            arg[loc] = '\0';
            RemoveRestrictedWeapons(arg);
            loc = 0;
        }
        else
        {
            arg[loc] = weaponsList[i];
            loc++;
        }
    }
}