/**
 * vim: set ts=4 :
 * =============================================================================
 * Weapon Restriction w/ Warmup Plugin for SourceMod
 * Restricts weapons for Counter-Strike: Source.
 *
 * SourceMod (C)2004-2007 AlliedModders LLC.  All rights reserved.
 * =============================================================================
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 3.0, as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * As a special exception, AlliedModders LLC gives you permission to link the
 * code of this program (as well as its derivative works) to "Half-Life 2," the
 * "Source Engine," the "SourcePawn JIT," and any Game MODs that run on software
 * by the Valve Corporation.  You must obey the GNU General Public License in
 * all respects for all other code used.  Additionally, AlliedModders LLC grants
 * this exception to all derivative works.  AlliedModders LLC defines further
 * exceptions, found in LICENSE.txt (as of this writing, version JULY-31-2007),
 * or <http://www.sourcemod.net/license.php>.
 *
 */

/* Used for ForceC4Drop */
new Handle:GameConf;
new Handle:CSWeaponDrop;

new String:g_RestrictTarget[MAXPLAYERS+1][64];

RestrictWeapon(client, String:weapon[], amount, String:team[])
{
    new f_Value;
    new String:f_Weapon[64];

    FormatWeaponName(weapon, f_Weapon, sizeof(f_Weapon));

    if(!GetTrieValue(g_T_Restrictions, f_Weapon, f_Value))
    {
        ReplyToCommand(client, "That is not a valid weapon.");
        ReplyToCommand(client, "Type 'buy' in console for a list of weapons.");
        return;
    }

    switch(team[0])
    {
        case '\0', 'a', 'A':
        {
            SetTrieValue(g_T_Restrictions, f_Weapon, amount);
            SetTrieValue(g_CT_Restrictions, f_Weapon, amount);
        }

        case 'c', 'C':
        {
            SetTrieValue(g_CT_Restrictions, f_Weapon, amount);
        }

        case 't', 'T':
        {
            SetTrieValue(g_T_Restrictions, f_Weapon, amount);
        }
    }

    if(client > 0)
    {
        ShowActivity2(client, "[SM] ", "%t", "Restricted Weapon", client, weapon);
        LogAction(client, -1, "\"%L\" restricted %s to %d for %s.", client, f_Weapon, amount, team);
    }
    RemoveRestrictedWeapons(weapon);
}

UnrestrictWeapon(client, String:weapon[], String:team[])
{
	new f_Value;
	new String:f_Weapon[64];
	new bool:f_All;

	if(!strcmp(weapon, "all", false))
		f_All = true;

	if(!f_All)
	{
		FormatWeaponName(weapon, f_Weapon, sizeof(f_Weapon));

		if(!GetTrieValue(g_T_Restrictions, f_Weapon, f_Value))
		{
			ReplyToCommand(client, "That is not a valid weapon.");
			ReplyToCommand(client, "Type 'buy' in console for a list of weapons.");
			return;
		}
	}

	switch(team[0])
	{
		case '\0', 'a', 'A':
        {
			if(f_All)
			{
				for(new i = 0; i < MAX_WEAPONS; i++)
				{
					SetTrieValue(g_T_Restrictions, g_WeaponNames[i], -1);
					SetTrieValue(g_CT_Restrictions, g_WeaponNames[i], -1);
				}
			}
			else
			{
				SetTrieValue(g_T_Restrictions, f_Weapon, -1);
				SetTrieValue(g_CT_Restrictions, f_Weapon, -1);
			}
		}

		case 'c', 'C':
		{
			if(f_All)
			{
				for(new i = 0; i < MAX_WEAPONS; i++)
					SetTrieValue(g_CT_Restrictions, g_WeaponNames[i], -1);
			}
			else
			{
				SetTrieValue(g_CT_Restrictions, f_Weapon, -1);
			}
		}

		case 't', 'T':
		{
			if(f_All)
			{
				for(new i = 0; i < MAX_WEAPONS; i++)
					SetTrieValue(g_T_Restrictions, g_WeaponNames[i], -1);
			}
			else
			{
				SetTrieValue(g_T_Restrictions, f_Weapon, -1);
			}
		}
	}

	if(client > 0)
	{
		ShowActivity2(client, "[SM] ", "%t", "UnRestricted Weapon", client, weapon);
		LogAction(client, -1, "\"%L\" unrestricted %s for %s.", client, f_Weapon, team);
	}
}

bool:IsRestricted(client, String:weapon[], bool:buying=false)
{
    new f_Team = (client == 0 ? CS_TEAM_SPECTATOR : client == -1 ? 9 : GetClientTeam(client));
    new f_AllowedAmount, f_AllowedAmountGroup_CT, f_AllowedAmountGroup_T;
    decl String:f_Weapon[64];

    if(client == 0 || weapon[0] == '\0')
        return false;

    FormatWeaponName(weapon, f_Weapon, sizeof(f_Weapon));
    f_AllowedAmountGroup_CT = FindGroupLimit(f_Weapon, CS_TEAM_CT);
    f_AllowedAmountGroup_T = FindGroupLimit(f_Weapon, CS_TEAM_T);

    switch(f_Team)
    {
        case CS_TEAM_SPECTATOR:
            return true;

        case CS_TEAM_CT:
        {
            GetTrieValue(g_CT_Restrictions, f_Weapon, f_AllowedAmount);

            if(f_AllowedAmount == -1 && f_AllowedAmountGroup_CT == -1)
                return false;

            if(f_AllowedAmount == 0 || f_AllowedAmountGroup_CT == 0)
                return true;
            else
            {
                new f_Count = CountCarriedWeapons(f_Weapon, CS_TEAM_CT);

                if(buying)
                {
                    if((f_AllowedAmount != -1 && f_Count >= f_AllowedAmount)
                        || (f_AllowedAmountGroup_CT != -1 && f_Count >= f_AllowedAmountGroup_CT))
                    {
                        return true;
                    }
                }
                else
                {
                    if((f_AllowedAmount != -1 && f_Count > f_AllowedAmount)
                        || (f_AllowedAmountGroup_CT != -1 && f_Count > f_AllowedAmountGroup_CT))
                    {
                        return true;
                    }
                }
                return false;
            }
        }

        case CS_TEAM_T:
        {
            GetTrieValue(g_T_Restrictions, f_Weapon, f_AllowedAmount);

            if(f_AllowedAmount == -1 && f_AllowedAmountGroup_T == -1)
                return false;

            if(f_AllowedAmount == 0 || f_AllowedAmountGroup_T == 0)
                return true;
            else
            {
                new f_Count = CountCarriedWeapons(f_Weapon, CS_TEAM_T);

                if(buying)
                {
                    if((f_AllowedAmount != -1 && f_Count >= f_AllowedAmount)
                        || (f_AllowedAmountGroup_T != -1 && f_Count >= f_AllowedAmountGroup_T))
                    {
                        return true;
                    }
                }
                else
                {
                    if((f_AllowedAmount != -1 && f_Count > f_AllowedAmount)
                        || (f_AllowedAmountGroup_T != -1 && f_Count > f_AllowedAmountGroup_T))
                    {
                        return true;
                    }
                }
                return false;
            }
        }

        case 9:
        {
            GetTrieValue(g_CT_Restrictions, f_Weapon, f_AllowedAmount);

            if(f_AllowedAmount >= 0 || f_AllowedAmountGroup_CT >= 0)
                return true;

            GetTrieValue(g_T_Restrictions, f_Weapon, f_AllowedAmount);

            if(f_AllowedAmount >= 0 || f_AllowedAmountGroup_T >= 0)
                return true;
        }
    }
    return false;
}

CountCarriedWeapons(String:weapon[], team)
{
    new f_Slot, f_ClientWeaponIndex, f_MaxClients = GetMaxClients( );
    decl String:f_UnfCarriedWeapon[64], String:f_CarriedWeapon[64];
    new f_Count, f_Team;

    GetTrieValue(g_WeaponSlots, weapon, f_Slot);

    for(new i = 1; i <= f_MaxClients; i++)
    {
        if(!IsClientConnected(i) || !IsClientInGame(i) || !IsPlayerAlive(i))
            continue;

        f_Team = GetClientTeam(i);
        f_ClientWeaponIndex = GetPlayerWeaponSlot(i, f_Slot);
        
        if(!IsValidEntity(f_ClientWeaponIndex) || !IsValidEdict(f_ClientWeaponIndex) || f_Team != team)
            continue;

        GetEdictClassname(f_ClientWeaponIndex, f_UnfCarriedWeapon, sizeof(f_UnfCarriedWeapon));
        FormatWeaponName(f_UnfCarriedWeapon, f_CarriedWeapon, sizeof(f_CarriedWeapon));
        
        if(!strncmp(weapon, f_CarriedWeapon, strlen(weapon), false))
            f_Count++;
    }
    return f_Count;
}

RemoveRestrictedWeapons(String:weapon[])
{
    new f_Slot, f_ClientWeaponIndex, f_MaxClients = GetMaxClients( );
    decl String:f_UnfCarriedWeapon[64], String:f_CarriedWeapon[64];
    new f_AllowedAmount_CT, f_AllowedAmount_T, f_Counted_CT, f_Counted_T, f_Team;
    new f_AllowedAmountGroup_CT, f_AllowedAmountGroup_T;

    GetTrieValue(g_WeaponSlots, weapon, f_Slot);
    GetTrieValue(g_T_Restrictions, weapon, f_AllowedAmount_T);
    GetTrieValue(g_CT_Restrictions, weapon, f_AllowedAmount_CT);
    f_AllowedAmountGroup_CT = FindGroupLimit(weapon, CS_TEAM_CT);
    f_AllowedAmountGroup_T = FindGroupLimit(weapon, CS_TEAM_T);


    for(new i = 1; i <= f_MaxClients; i++)
    {
        if(!IsClientConnected(i) || !IsClientInGame(i) || !IsPlayerAlive(i))
            continue;

        f_Team = GetClientTeam(i);
        f_ClientWeaponIndex = GetPlayerWeaponSlot(i, f_Slot);
        
        if(!IsValidEntity(f_ClientWeaponIndex) || !IsValidEdict(f_ClientWeaponIndex))
            continue;

        GetEdictClassname(f_ClientWeaponIndex, f_UnfCarriedWeapon, sizeof(f_UnfCarriedWeapon));
        FormatWeaponName(f_UnfCarriedWeapon, f_CarriedWeapon, sizeof(f_CarriedWeapon));
        
        if(!strncmp(weapon, f_CarriedWeapon, strlen(weapon), false))
        {
            switch(f_Team)
            {
                case CS_TEAM_CT:
                {
                    f_Counted_CT++;

                    if((f_AllowedAmount_CT != -1 && f_Counted_CT > f_AllowedAmount_CT)
                        || (f_AllowedAmountGroup_CT != -1 && f_Counted_CT > f_AllowedAmountGroup_CT))
                    {
                        RemoveWeapon(i, weapon);
                    }
                }

                case CS_TEAM_T:
                {
                    f_Counted_T++;

                    if((f_AllowedAmount_T != -1 && f_Counted_T > f_AllowedAmount_T)
                        || (f_AllowedAmountGroup_T != -1 && f_Counted_T > f_AllowedAmountGroup_T))
                    {
                        RemoveWeapon(i, weapon);
                    }
                }
            }
        }
    }
    RemoveDroppedWeapons( );
}

RemoveDroppedWeapons( )
{
    new f_Max = GetMaxEntities( );
    decl String:f_EntName[MAX_NAME_LENGTH];

    for(new i = 1; i <= f_Max; i++)
    {
        if(!IsValidEntity(i)
            || !IsValidEdict(i))
            continue;

        f_EntName[0] = '\0';
        
        if(!GetEdictClassname(i, f_EntName, sizeof(f_EntName)))
            continue;

        if(StrContains(f_EntName, "weapon_", false) == -1)
            continue;

        
        if(IsRestricted(-1, f_EntName)
            && GetEntPropEnt(i, Prop_Send, "m_hOwnerEntity") == -1)
        {
            RemoveEdict(i);
        }
    }
}

FormatWeaponName(String:weapon[], String:target[], size)
{
    for(new i = 0; i < MAX_WEAPONS; i++)
    {
        if(weapon[0] == 'w' || weapon[0] == 'W')
        {
            if(StrContains(g_WeaponNames[i], weapon[7], false) != -1)
            {
                strcopy(target, size, g_WeaponNames[i]);
                break;
            }
        }
        else
        {
            if(StrContains(g_WeaponNames[i], weapon, false) != -1)
            {
                strcopy(target, size, g_WeaponNames[i]);
                break;
            }
        }
    }
}

RemoveWeapon(client, String:weapon[], bool:pickedUp=false)
{
    new slot, next_weapon, curr_weapon;
    GetTrieValue(g_WeaponSlots, weapon, slot);
    curr_weapon = GetPlayerWeaponSlot(client, slot);

    if(client == 0 || !IsValidEntity(curr_weapon))
        return;

    for(new i = 0; i < 5; i++)
    {
        if(i == slot)
            continue;
        
        if((next_weapon = GetPlayerWeaponSlot(client, i)) != -1)
            break;
    }
    RemovePlayerItem(client, curr_weapon);
    RefundWeaponCost(client, weapon, pickedUp);
    EquipPlayerWeapon(client, next_weapon);
}

RefundWeaponCost(client, String:weapon[], bool:pickedup)
{
    if(pickedup == true)
        return;

    new f_WeaponCost;

    GetTrieValue(g_WeaponCosts, weapon, f_WeaponCost);

    new f_NewMoney = f_WeaponCost + GetEntData(client, g_iAccount);

    PrintToChat(client, "You are refunded %d cash for the %s.", f_WeaponCost, weapon);

    if(f_NewMoney <= 16000)
        SetEntData(client, g_iAccount, f_NewMoney);
    else
        SetEntData(client, g_iAccount, 16000);
}

/* Used for ForceC4Drop( ) */
CreateDropHack()
{
	StartPrepSDKCall(SDKCall_Player);
	PrepSDKCall_SetFromConf(GameConf, SDKConf_Signature, "CSWeaponDrop");
	PrepSDKCall_AddParameter(SDKType_CBaseEntity, SDKPass_Pointer);
	PrepSDKCall_AddParameter(SDKType_Bool, SDKPass_Plain);
	PrepSDKCall_AddParameter(SDKType_Bool, SDKPass_Plain);
	CSWeaponDrop = EndPrepSDKCall();

	if(CSWeaponDrop == INVALID_HANDLE)
	{
		SetFailState("Signature CSSPlayer::CSWeaponDrop Failed. Please contact the author.");
	}
}

HACK_CSWeaponDrop(client, weapon)
{
	SDKCall(CSWeaponDrop, client, weapon, true, false);
}

bool:ForceC4Drop( )
{
    new f_Entity;
    new f_MaxClients = GetMaxClients( );

    for(new i = 1; i < f_MaxClients; i++)
    {
        if(IsClientConnected(i) && IsClientInGame(i) && !IsClientObserver(i))
        {
            if((f_Entity = GetPlayerWeaponSlot(i, CS_SLOT_C4)) != -1)
            {
                HACK_CSWeaponDrop(i, f_Entity);
                return true;
            }
        }
    }
    return false;
}
#if STOCK_MENUS
DisplayWeaponTargetMenu(client)
{
    new Handle:menu = CreateMenu(MenuHandler_RestrictWeapon);

    decl String:title[100];

    Format(title, sizeof(title), "%T:", "Restrict Weapon", client);
    SetMenuTitle(menu, title);
    SetMenuExitBackButton(menu, true);
    AddWeaponsToMenu(menu);
    DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

DisplayRestrictAmountMenu(client)
{
	new Handle:menu = CreateMenu(MenuHandler_RestrictAmountList);
	
	decl String:title[100];
	Format(title, sizeof(title), "%T:", "Restrict Weapon", client);
	SetMenuTitle(menu, title);
	SetMenuExitBackButton(menu, true);
	
	AddMenuItem(menu, "0", "0");
	AddMenuItem(menu, "1", "1");
	AddMenuItem(menu, "2", "2");
	AddMenuItem(menu, "3", "3");
	AddMenuItem(menu, "4", "4");
	AddMenuItem(menu, "5", "5");
	AddMenuItem(menu, "6", "6");
	
	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

AddWeaponsToMenu(Handle:menu)
{
	decl String:f_Weapon[64];
	
	for(new i = 6; i < MAX_WEAPONS; i++)
    {
        Format(f_Weapon, sizeof(f_Weapon), "%s%s", 
            (IsRestricted(-1, g_WeaponNames[i]) ? "*" : ""), g_WeaponNames[i]);

        AddMenuItem(menu, g_WeaponNames[i], f_Weapon);
    }
}

public AdminMenu_Restrict(Handle:topmenu, 
							  TopMenuAction:action,
							  TopMenuObject:object_id,
							  param,
							  String:buffer[],
							  maxlength)
{
	if (action == TopMenuAction_DisplayOption)
	{
		Format(buffer, maxlength, "%T", "Restrict Weapon", param);
	}
	else if (action == TopMenuAction_SelectOption)
	{
		DisplayWeaponTargetMenu(param);	
	}
}

public AdminMenu_DropC4(Handle:topmenu, 
							  TopMenuAction:action,
							  TopMenuObject:object_id,
							  param,
							  String:buffer[],
							  maxlength)
{
	if (action == TopMenuAction_DisplayOption)
	{
		Format(buffer, maxlength, "%T", "DropC4", param);
	}
	else if (action == TopMenuAction_SelectOption)
	{
		Command_DropC4(param, 0);	
	}
}

public MenuHandler_RestrictWeapon(Handle:menu, MenuAction:action, param1, param2)
{
    if(action == MenuAction_End)
        CloseHandle(menu);
    else if(action == MenuAction_Cancel)
    {
        if(param2 == MenuCancel_ExitBack && hTopMenu != INVALID_HANDLE)
            DisplayTopMenu(hTopMenu, param1, TopMenuPosition_LastCategory);
    }
    else if(action == MenuAction_Select)
    {
        decl String:f_Weapon[64];

        GetMenuItem(menu, param2, f_Weapon, sizeof(f_Weapon));

        if(IsRestricted(-1, f_Weapon))
            UnrestrictWeapon(param1, f_Weapon, "all");
        else
        {
            strcopy(g_RestrictTarget[param1], 64, f_Weapon);
            DisplayRestrictAmountMenu(param1);
        }
    }
}

public MenuHandler_RestrictAmountList(Handle:menu, MenuAction:action, param1, param2)
{
	if (action == MenuAction_End)
	{
		CloseHandle(menu);
	}
	else if (action == MenuAction_Cancel)
	{
		if (param2 == MenuCancel_ExitBack && hTopMenu != INVALID_HANDLE)
		{
			DisplayTopMenu(hTopMenu, param1, TopMenuPosition_LastCategory);
		}
	}
	else if (action == MenuAction_Select)
	{
		decl String:info[32];
		
		GetMenuItem(menu, param2, info, sizeof(info));
		RestrictWeapon(param1, g_RestrictTarget[param1], StringToInt(info), "all");
		g_RestrictTarget[param1][0] = '\0';
	}
}
#endif