/**
 * vim: set ts=4 :
 * =============================================================================
 * Weapon Restriction w/ Warmup Plugin for SourceMod
 * Restricts weapons for Counter-Strike: Source.
 *
 * SourceMod (C)2004-2007 AlliedModders LLC.  All rights reserved.
 * =============================================================================
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 3.0, as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * As a special exception, AlliedModders LLC gives you permission to link the
 * code of this program (as well as its derivative works) to "Half-Life 2," the
 * "Source Engine," the "SourcePawn JIT," and any Game MODs that run on software
 * by the Valve Corporation.  You must obey the GNU General Public License in
 * all respects for all other code used.  Additionally, AlliedModders LLC grants
 * this exception to all derivative works.  AlliedModders LLC defines further
 * exceptions, found in LICENSE.txt (as of this writing, version JULY-31-2007),
 * or <http://www.sourcemod.net/license.php>.
 *
 */

#define MAX_WARMUP_WEAPONS 7

new Handle:g_Cvar_Warmup = INVALID_HANDLE;
new Handle:g_Cvar_Warmup_System = INVALID_HANDLE;
new Handle:g_Cvar_Warmup_Time = INVALID_HANDLE;
new bool:g_WarmupRunning = false;
new g_WarmupWeapon;
new g_WarmupTimeLeft;
new g_WarmupWeaponCount;
new String:g_WarmupWeapons[MAX_WEAPONS][64];

InitializeWarmup( )
{
    if(GetConVarInt(g_Cvar_Warmup_System) == 0)
        return;

    LoadWarmupWeapons( );
    g_WarmupWeapon = GetRandomInt(0, g_WarmupWeaponCount-1);
    if(g_WarmupWeaponCount == 0)
    {
        SetFailState("Warmup.cfg doesn't have any weapon in it.");
        return;
    }
    g_WarmupRunning = true;
    g_WarmupTimeLeft = GetConVarInt(g_Cvar_Warmup_Time);
    SetConVarInt(g_Cvar_Warmup, 1);
    CreateTimer(1.0, Timer_Warmup, _, TIMER_REPEAT|TIMER_FLAG_NO_MAPCHANGE);
}

LoadWarmupWeapons( )
{
    decl String:filename[64];

    BuildPath(Path_SM, filename, sizeof(filename), "configs/warmup.cfg");
    g_WarmupWeaponCount = 0;

    if(!FileExists(filename, false))
    {
        SetFailState("File %s does not exist.", filename);
        return;
    }

    new Handle:file = OpenFile(filename, "rt");

    if(file == INVALID_HANDLE)
    {
        LogError("LoadWarmupWeapons( ): warmup.cfg is missing.");
        SetFailState("Warmup.cfg is missing from %s", filename);
        return;
    }

    while(IsEndOfFile(file) == false)
    {
        decl String:line[256];
        ReadFileLine(file, line, sizeof(line));

        if(line[0] == '\0' || line[0] == '/')
            continue;

        TrimString(line);
        Format(g_WarmupWeapons[g_WarmupWeaponCount], 64, "%s", line);
        g_WarmupWeaponCount++;
    }
    CloseHandle(file);
    file = INVALID_HANDLE;
}     

public Action:Event_PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast)
{
    if(g_WarmupRunning)
    {
        new f_Client = GetClientOfUserId(GetEventInt(event, "userid"));
        
        if(IsClientInGame(f_Client) && IsPlayerAlive(f_Client))        
            GiveWarmupItem(f_Client);
    }
    return Plugin_Continue;
}

GiveWarmupItem(client)
{
    new f_Team = GetClientTeam(client);

    switch(f_Team)
    {
        case CS_TEAM_CT, CS_TEAM_T:
        {
            decl String:weapon[64];
            Format(weapon, sizeof(weapon), "weapon_%s", g_WarmupWeapons[g_WarmupWeapon]);
            GivePlayerItem(client, weapon);
        }
    }
}

public Action:Timer_Warmup(Handle:timer)
{
    if(g_WarmupTimeLeft > 1)
    {
        g_WarmupTimeLeft--;
        PrintCenterTextAll("Warmup Round: %d seconds remaining.", g_WarmupTimeLeft);
    }
    else
    {
        g_WarmupRunning = false;
        RestartRound( );
        return Plugin_Stop;
    }
    return Plugin_Continue;
}

RestartRound( )
{
    InsertServerCommand("mp_restartgame 1");
    ServerExecute( );
    CreateTimer(2.0, Timer_WarmupStop);
}

public Action:Timer_WarmupStop(Handle:timer)
{
    SetConVarInt(g_Cvar_Warmup, 0);
}