/**
 * vim: set ts=4 :
 * =============================================================================
 * Weapon Restriction w/ Warmup Plugin for SourceMod
 * Restricts weapons for Counter-Strike: Source.
 *
 * SourceMod (C)2004-2007 AlliedModders LLC.  All rights reserved.
 * =============================================================================
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 3.0, as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * As a special exception, AlliedModders LLC gives you permission to link the
 * code of this program (as well as its derivative works) to "Half-Life 2," the
 * "Source Engine," the "SourcePawn JIT," and any Game MODs that run on software
 * by the Valve Corporation.  You must obey the GNU General Public License in
 * all respects for all other code used.  Additionally, AlliedModders LLC grants
 * this exception to all derivative works.  AlliedModders LLC defines further
 * exceptions, found in LICENSE.txt (as of this writing, version JULY-31-2007),
 * or <http://www.sourcemod.net/license.php>.
 *
 */

public OnMapStart( )
{
    ServerCommand("exec sourcemod\\restrict_weapons.cfg");
#if WARMUP
    if(GetConVarInt(g_Cvar_Warmup_System) != 0)
        CreateTimer(1.0, Timer_StartWarmup);
#endif
}

#if WARMUP
public Action:Timer_StartWarmup(Handle:timer)
{
    InitializeWarmup( );
    return Plugin_Stop;
}
#endif

public OnMapEnd( )
{
    for(new i = 0; i < MAX_WEAPONS; i++)
    {
        SetTrieValue(g_T_Restrictions, g_WeaponNames[i], -1);
        SetTrieValue(g_CT_Restrictions, g_WeaponNames[i], -1);
    }
    ResetConVars( );    
}

public Action:Event_WeaponFire(Handle:event, const String:name[], bool:dontBroadcast)
{
    new f_Client = GetClientOfUserId(GetEventInt(event, "userid"));
    decl String:f_Weapon[64];

    if(f_Client == 0)
        return Plugin_Continue;

#if WARMUP
    if(g_WarmupRunning && g_WarmupWeapon == 0) // for hegrenade
    {
        GiveWarmupItem(f_Client);
        return Plugin_Handled;
    }
#endif

    GetEventString(event, "weapon", f_Weapon, sizeof(f_Weapon));

    if(IsRestricted(f_Client, f_Weapon))
    {
        PrintToChat(f_Client, "That weapon is currently restricted.");
        RemoveWeapon(f_Client, f_Weapon);
        return Plugin_Handled;
    }
    return Plugin_Continue;    
}

public Action:Event_ItemPickup(Handle:event, const String:name[], bool:dontBroadcast)
{
    new f_Client = GetClientOfUserId(GetEventInt(event, "userid"));
    decl String:f_Weapon[64];

    GetEventString(event, "item", f_Weapon, sizeof(f_Weapon));

#if WARMUP
    if(g_WarmupRunning == true)
    {
        if((strncmp(g_WarmupWeapons[g_WarmupWeapon], f_Weapon, strlen(f_Weapon), false) != 0)
            && (strncmp("knife", f_Weapon, strlen(f_Weapon), false) != 0)
            && (strncmp("c4", f_Weapon, strlen(f_Weapon), false) != 0))
        {
            RemoveWeapon(f_Client, f_Weapon, true);
            return Plugin_Handled;
        }
    }
#endif

    if(IsRestricted(f_Client, f_Weapon))
    {
        PrintToChat(f_Client, "That weapon is currently restricted.");
        RemoveWeapon(f_Client, f_Weapon, true);
        return Plugin_Handled;
    }
    return Plugin_Continue;    
}