/**
 * vim: set ts=4 :
 * =============================================================================
 * Weapon Restriction w/ Warmup Plugin for SourceMod
 * Restricts weapons for Counter-Strike: Source.
 *
 * SourceMod (C)2004-2007 AlliedModders LLC.  All rights reserved.
 * =============================================================================
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 3.0, as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * As a special exception, AlliedModders LLC gives you permission to link the
 * code of this program (as well as its derivative works) to "Half-Life 2," the
 * "Source Engine," the "SourcePawn JIT," and any Game MODs that run on software
 * by the Valve Corporation.  You must obey the GNU General Public License in
 * all respects for all other code used.  Additionally, AlliedModders LLC grants
 * this exception to all derivative works.  AlliedModders LLC defines further
 * exceptions, found in LICENSE.txt (as of this writing, version JULY-31-2007),
 * or <http://www.sourcemod.net/license.php>.
 *
 */

public Action:Command_Restrict(client, args)
{
    if(args < 1)
    {
        ReplyToCommand(client, "Usage: sm_restrict <weapon> <amount> <team>");
        ReplyToCommand(client, "You can type 'buy' in console to view weapon names.");
        return Plugin_Handled;
    }
    decl String:weapon[64], String:amount[64], String:team[64];

    GetCmdArg(1, weapon, sizeof(weapon));
    GetCmdArg(2, amount, sizeof(amount));
    GetCmdArg(3, team, sizeof(team));

    if(IsWeaponGroup(weapon))
    {
        RestrictWeaponsGroup(client, weapon, StringToInt(amount), team);
    }
    else
    {
        RestrictWeapon(client, weapon, StringToInt(amount), team);
    }
    return Plugin_Handled;
}

public Action:Command_Unrestrict(client, args)
{
    if(args < 1)
    {
        ReplyToCommand(client, "Usage: sm_unrestrict <all|weapon> <team>");
        ReplyToCommand(client, "You can type 'buy' in console to view weapon names.");
        return Plugin_Handled;
    }
    decl String:weapon[64], String:team[64];

    GetCmdArg(1, weapon, sizeof(weapon));
    GetCmdArg(2, team, sizeof(team));
    
    if(IsWeaponGroup(weapon))
    {
        UnrestrictWeaponsGroup(client, weapon, team);
    }
    else
    {
        UnrestrictWeapon(client, weapon, team);
    }
    return Plugin_Handled;
}

public Action:Command_DropC4(client, args)
{
    if(ForceC4Drop( ))
    {
        decl String:name[MAX_NAME_LENGTH];

        GetClientName(client, name, sizeof(name));
        PrintToChatAll("%s caused the C4 bomb to be dropped.", name);
        LogAction(client, -1, "\"%L\" forced the C4 bomb to be dropped.", client);
    }
    else
        ReplyToCommand(client, "The bomb isn't being carried by anyone.");
    return Plugin_Handled;
}

public Action:Command_Buy(client, args)
{
    decl String:f_Weapon[64];

#if WARMUP
    if(g_WarmupRunning)
    {
        PrintToChat(client, "You cannot buy anything during the warmup round.");
        return Plugin_Handled;
    }
#endif

    GetCmdArg(1, f_Weapon, sizeof(f_Weapon));

    if(IsRestricted(client, f_Weapon, true))
    {
        PrintToChat(client, "That weapon is currently restricted.");
        return Plugin_Handled;
    }
    return Plugin_Continue;
}