
-- Pfftt.. I don't wanna remake my PenetratingTrace function.
_OpenScript( "objects/objects.lua" );

PORTAL_CREATED = false;
PORTAL_LIFE = _CurTime() + 10;

-- Point camera.
CAMERA = nil;
CAMERA_LINK = nil;

-- Portals.
PORTAL_ONE_ENTITY = nil;
PORTAL_TWO_ENTITY = nil;
PORTAL_ONE_CREATED = false;
PORTAL_ONE_LOCATION = vector3( 0, 0, 0 );
PORTAL_TWO_LOCATION = vector3( 0, 0, 0 );
PORTAL_ONE_NORMAL = vector3( 0, 0, 0 );
PORTAL_TWO_NORMAL = vector3( 0, 0, 0 );
PORTAL_ONE_CREATE = _CurTime();
PORTAL_TWO_CREATE = _CurTime();

Velocities = {};
for i = 1, 2048 do
    Velocities[i] = {};
    Velocities[i].lastpos = vector3(0,0,0);
    Velocities[i].velocity = vector3(0,0,0);
end

Balls = {};

function FireBall( player, balltype )
    local iBall = _EntCreate( "prop_physics" );
    _EntPrecacheModel( "models/pinkball.mdl" );
    _EntSetModel( iBall, "models/pinkball.mdl" );
    _EntSetPos( iBall, vecAdd( vecAdd( _PlayerGetShootPos( player ), vecMul( _EntGetRightVector( player ), 8 ) ), vecMul( _EntGetUpVector( player ), -8 ) ) );
    _EntSetAng( iBall, _PlayerGetShootAng( player ) );
    
    _EntSetSolid( iBall, SOLID_NONE );
    _EntSetCollisionGroup( iBall, COLLISION_GROUP_DEBRIS );
    _EntSetOwner( iBall, player );
    
    _EntSpawn( iBall );
    
    _phys.EnableCollisions( iBall, false );
    _phys.EnableGravity( iBall, false );
    _phys.ApplyForceCenter( iBall, vecMul( _PlayerGetShootAng( player ), 150000 ) );
    
    local ball = {};
    ball.ent = iBall;
    ball.type = balltype;
    ball.tracedir = _PlayerGetShootAng( player );
    ball.player = player;
    
    _EntEmitSound( player, "portal/fireblob.wav" );
    
    table.insert( Balls, ball );
end

-- Create portal hole.
function PortalHole( player )
    -- Trace from player.
    local tr = Trace:Line( _PlayerGetShootPos( player ), _PlayerGetShootAng( player ), 4096, player );
    
    -- Hit a wall?
    if( tr.hit ) then
        -- Trace along the objects normal to find entry and exit points.
        tr = Trace:PenetratingLine( tr.endpos, tr.normal * -1, 32, nil, 1, 128 );
        if( table.getn( tr ) < 2 ) then
            return;
        else
            -- Enough hits, create portals.
            
            -- Exit.
            if( _EntExists( PORTAL_ONE_ENTITY ) ) then
                _EntFire( PORTAL_ONE_ENTITY, "setanimation", "close2", 0 );
                _EntFire( PORTAL_ONE_ENTITY, "kill", "", 1 );
                PORTAL_ONE_ENTITY = nil;
            end
            
            local iRift = _EntCreate( "prop_dynamic_override" );
            _EntPrecacheModel( "models/effects/portalrift_small.mdl" );
            _EntSetModel( iRift, "models/effects/portalrift_small.mdl" );
            _EntSetPos( iRift, ( tr[2].endpos + ( tr[2].normal * 3 ) ):GetVector3() );
            --_EntSetKeyValue( iRift, "targetname", "portal_exit" );
            _EntSetKeyValue( iRift, "disableshadows", "1" );
            local vAng = VecToAngles( tr[2].normal:GetVector3() );
            vAng.x = vAng.x - 90;
            _EntSetAngAngle( iRift, vAng );
            _EntSpawn( iRift );
            _EntSetMaterial( iRift, "portalrift_exit" );
            
            PORTAL_ONE_CREATE = _CurTime();
            PORTAL_ONE_ENTITY = iRift;
            PORTAL_ONE_LOCATION = tr[2].endpos:GetVector3();
            PORTAL_ONE_NORMAL = tr[2].normal:GetVector3();
            
            -- Move the camera to the same location.
            _EntSetPos( CAMERA, ( tr[1].endpos + ( tr[2].normal * 32 ) ):GetVector3() );
            _EntSetAngAngle( CAMERA, VecToAngles( tr[2].normal:GetVector3() ) );
            _EntFire( iRift, "setanimation", "open2", 0 );
            
            -- Entrance.
            if( _EntExists( PORTAL_TWO_ENTITY ) ) then
                _EntFire( PORTAL_TWO_ENTITY, "setanimation", "close2", 0 );
                _EntFire( PORTAL_TWO_ENTITY, "kill", "", 1 );
                PORTAL_TWO_ENTITY = nil;
            end
            
            _EntEmitSound( player, "portal/fireblob.wav" );
            
            
            -- Create a new entrance.
            local iRift = _EntCreate( "prop_dynamic" );
            _EntPrecacheModel( "models/effects/portalrift_small.mdl" );
            _EntSetModel( iRift, "models/effects/portalrift_small.mdl" );
            _EntSetPos( iRift, ( tr[1].endpos + ( tr[1].normal * 3 ) ):GetVector3() );
            _EntSetKeyValue( iRift, "targetname", "portal_exit" );
            _EntSetKeyValue( iRift, "disableshadows", "1" );
            local vAng = VecToAngles( tr[1].normal:GetVector3() );
            vAng.x = vAng.x - 90;
            _EntSetAngAngle( iRift, vAng );
            _EntSpawn( iRift );
            _EntFire( iRift, "setanimation", "open2", 0 );
            
            PORTAL_TWO_CREATE = _CurTime();
            PORTAL_TWO_ENTITY = iRift;
            PORTAL_TWO_LOCATION = tr[1].endpos:GetVector3();
            PORTAL_TWO_NORMAL = tr[1].normal:GetVector3();
            
            
        end
    end
end

-- Create cameras.
function PortalMakeCameras( )
    -- Create camera if it doesn't exist.
    if( not CAMERA or not _EntExists( CAMERA ) ) then
        CAMERA = _EntCreate( "point_camera" );
        _EntSetKeyValue( CAMERA, "targetname", "portal_camera" );
        _EntSetKeyValue( CAMERA, "angles", "0 0 0" );
        _EntSetKeyValue( CAMERA, "FOV", "90" );
        _EntSetKeyValue( CAMERA, "fogColor", "0 0 0" );
        _EntSetKeyValue( CAMERA, "fogStart", "2048" );
        _EntSetKeyValue( CAMERA, "fogEnd", "4096" );
        _EntSpawn( CAMERA );
        _EntActivate( CAMERA );
    end
    
    -- Create the camera link.
    if( not CAMERA_LINK or not _EntExists( CAMERA_LINK ) ) then
        CAMERA_LINK = _EntCreate( "info_camera_link" );
        _EntSetKeyValue( CAMERA_LINK, "targetname", "portal_link" );
        _EntSetKeyValue( CAMERA_LINK, "target", "portal_exit" );
        _EntSetKeyValue( CAMERA_LINK, "PointCamera", "portal_camera" );
        _EntSpawn( CAMERA_LINK );
        _EntActivate( CAMERA_LINK );
    end
end

--_EntPrecacheModel( "models/props_trainstation/trainstation_clock001.mdl" );
            --_EntSetModel( iRift, "models/props_trainstation/trainstation_clock001.mdl" );
            
function PortalPrimary( )

    --[[PlayerLookTrace( player, 4096 );
    
    if( not _TraceHit( ) ) then
        return;
    end]]
    
    if( _EntExists( PORTAL_TWO_ENTITY ) ) then
        _EntFire( PORTAL_TWO_ENTITY, "setanimation", "close2", 0 );
        _EntFire( PORTAL_TWO_ENTITY, "kill", "", 1 );
        PORTAL_TWO_ENTITY = nil;
    end
    
    
    
    -- Create a new entrance.
    local iRift = _EntCreate( "prop_dynamic" );
    _EntPrecacheModel( "models/effects/portalrift_small.mdl" );
    _EntSetModel( iRift, "models/effects/portalrift_small.mdl" );
    _EntSetPos( iRift, vecAdd( _TraceEndPos(), vecMul( _TraceGetSurfaceNormal( ), 3 ) ) );
    _EntSetKeyValue( iRift, "targetname", "portal_exit" );
    _EntSetKeyValue( iRift, "disableshadows", "1" );
    local vAng = VecToAngles( _TraceGetSurfaceNormal() );
    vAng.x = vAng.x - 90;
    _EntSetAngAngle( iRift, vAng );
    _EntSpawn( iRift );
    _EntFire( iRift, "setanimation", "open2", 0 );
    
    PORTAL_TWO_CREATE = _CurTime();
    PORTAL_TWO_ENTITY = iRift;
    PORTAL_TWO_LOCATION = _EntGetPos( iRift );
    PORTAL_TWO_NORMAL = _TraceGetSurfaceNormal();
end

function PortalSecondary( )
    --[[PlayerLookTrace( player, 4096 );
    
    if( not _TraceHit( ) ) then
        return;
    end]]
    
    if( _EntExists( PORTAL_ONE_ENTITY ) ) then
        _EntFire( PORTAL_ONE_ENTITY, "setanimation", "close2", 0 );
        _EntFire( PORTAL_ONE_ENTITY, "kill", "", 1 );
        PORTAL_ONE_ENTITY = nil;
    end
    

    local iRift = _EntCreate( "prop_dynamic_override" );
    _EntPrecacheModel( "models/effects/portalrift_small.mdl" );
    _EntSetModel( iRift, "models/effects/portalrift_small.mdl" );
    _EntSetPos( iRift, vecAdd( _TraceEndPos(), vecMul( _TraceGetSurfaceNormal( ), 3 ) ) );
    --_EntSetKeyValue( iRift, "targetname", "portal_exit" );
    _EntSetKeyValue( iRift, "disableshadows", "1" );
    local vAng = VecToAngles( _TraceGetSurfaceNormal() );
    vAng.x = vAng.x - 90;
    _EntSetAngAngle( iRift, vAng );
    _EntSpawn( iRift );
    _EntSetMaterial( iRift, "portalrift_exit" );
    
    PORTAL_ONE_CREATE = _CurTime();
    PORTAL_ONE_ENTITY = iRift;
    PORTAL_ONE_LOCATION = _EntGetPos( iRift );
    PORTAL_ONE_NORMAL = _TraceGetSurfaceNormal();
    
    -- Move the camera to the same location.
    _EntSetPos( CAMERA, vecAdd( PORTAL_ONE_LOCATION, vecMul( _TraceGetSurfaceNormal(), 32 ) ) );
    _EntSetAngAngle( CAMERA, VecToAngles( _TraceGetSurfaceNormal() ) );
    _EntFire( iRift, "setanimation", "open2", 0 );
end

-- Think.
--------------------------------
-- If anything gets near the portal, suck it in.
function PortalThink()

    -- Balls.
    for key, ball in Balls do
        if( not _EntExists( ball.ent ) ) then
            table.remove( Balls, key );
        else
            _TraceLine( _EntGetPos( ball.ent ), ball.tracedir, 32, ball.player );
            if( _TraceHit() ) then
                _EntRemove( ball.ent );
                if( ball.type == 1 ) then
                    PortalPrimary( );
                else
                    PortalSecondary( );
                end
            end
        end
    end

    -- Prop velocity.
    for i = 33, 2048 do
        if( _EntExists( i ) and _phys.HasPhysics( i ) ) then
            Velocities[i].velocity = 100 * _phys.GetMass( i ) * vecLength( vecSub( _EntGetPos( i ), Velocities[i].lastpos ) );
            Velocities[i].lastpos = _EntGetPos( i );
        end
    end

    -- Monitor blobs for impacts.
    if( not _EntExists( PORTAL_ONE_ENTITY ) or not _EntExists( PORTAL_TWO_ENTITY ) ) then
        return;
    end
    
    -- Are both fully open?
    if( PORTAL_ONE_CREATE + 1 > _CurTime() or PORTAL_TWO_CREATE + 1 > _CurTime() ) then
        return;
    end
    
    --[[_EffectInit();
    _EffectSetEnt( 255 );
    _EffectSetOrigin( PORTAL_TWO_LOCATION );
    _EffectSetStart( vecAdd( PORTAL_TWO_LOCATION, vecMul( PORTAL_TWO_NORMAL, 128 ) ) );
    _EffectSetScale( 5 );
    _EffectSetMagnitude( 0.5 );
    _EffectDispatch( "FadingLine" );
    
    _EffectInit();
    _EffectSetEnt( 255 );
    _EffectSetOrigin( PORTAL_ONE_LOCATION );
    _EffectSetStart( vecAdd( PORTAL_ONE_LOCATION, vecMul( PORTAL_ONE_NORMAL, 128 ) ) );
    _EffectSetScale( 5 );
    _EffectSetMagnitude( 0.5 );
    _EffectDispatch( "FadingLine" );]]
    
    -- Find entities in sphere.
    local nearbyents = _EntitiesFindInSphere( PORTAL_TWO_LOCATION, 24 );
    for _, entity in nearbyents do
        if( entity ~= PORTAL_TWO_ENTITY and entity ~= PORTAL_ONE_ENTITY ) then
            -- Wake it up.
            _phys.EnableMotion( entity, true );
            _phys.Wake( entity );
            
            -- Get velocity.
            local vel = vecLength( _EntGetVelocity( entity ) );
            local t = _EntGetType( entity );
            if( string.find( t, "prop_" ) ~= nil or string.find( t, "weapon_" ) ~= nil or t == "npc_grenade_frag" or t == "npc_satchel" ) then
                vel = Velocities[entity].velocity;
            end
            
            -- Figure out z difference.
            local zDiff = PORTAL_TWO_LOCATION.z - _EntGetPos( entity ).z;
            
            -- Transport entity.
            local portaloffset = 32;
            
            -- Quick hack ;)
            local tolerance = 0.1;
            local pang = _EntGetAngAngle( PORTAL_ONE_ENTITY );
            if( pang.x == -180 and pang.y == 0 and pang.z == 0 ) then
                if( _EntGetType( entity ) == "player" or string.find( _EntGetType( entity ), "npc_" ) ~= nil ) then
                    portaloffset = 0;
                    zDiff = 0;
                end
            end
            if( pang.x == 0 and pang.y == 0 and pang.z == 0 ) then
                if( _EntGetType( entity ) == "player" or string.find( _EntGetType( entity ), "npc_" ) ~= nil ) then
                    portaloffset = 72;
                    zDiff = 0;
                end
            end
            
            _EntSetPos( entity, vecSub( vecAdd( PORTAL_ONE_LOCATION, vecMul( PORTAL_ONE_NORMAL, portaloffset ) ), vector3(0,0,zDiff) ) );
        
            -- Get our angle.
            local ang = _EntGetAngAngle( entity );
    
            local a = _EntGetAngAngle( PORTAL_ONE_ENTITY ).y;
            local pa = _EntGetAngAngle( entity ).y;
            local b = _EntGetAngAngle( PORTAL_TWO_ENTITY ).y;

            --ang.y = ClampAngle( ( ClampAngle( b ) - ClampAngle( a ) ) + ClampAngle( pa ) );
            ang.y = a;
            --angle B portal - ( angle A portal - angle A player) = angle B player
            
            -- Rotate us by yaw.
            _EntSetAngAngle( entity, ang );
            
            -- Set new velocity.
            if( string.find( t, "prop_" ) ~= nil or string.find( t, "weapon_" ) ~= nil or t == "npc_frag_grenade" or t == "npc_satchel" ) then
                _phys.ApplyForceCenter( entity, vecMul( PORTAL_ONE_NORMAL, vel ) );
            else
                --_EntSetVelocity( entity, vecMul( PORTAL_ONE_NORMAL, vel ) );
            end
        end
    end
end
AddThinkFunction( PortalThink );

-- Some utility functions.
--------------------------------
function WrapAngle( ang )
    local angle = ang;
    if( angle < -180 ) then
        angle = angle + 360 * math.abs( math.floor( angle - 180 ) / 360 );
    elseif( angle >= 180 ) then
        angle = angle - 360 * math.abs( math.floor( angle + 180 ) / 360 );
    end
    
    if( angle == 180 ) then
        angle = -180;
    end

    return angle;
end

function ClampAngle( ang )
    local angle = ang;
    if( angle >= 360 ) then
        angle = angle - 360;
    end
    if( angle < 0 ) then
        angle = angle + 360;
    end
end

function VecToAngles( vec )
    local vAng = vector3(0,0,0);
    if( vec.y == 0 and vec.x == 0 ) then
        if( vec.z > 0 ) then
            vAng.x = 90;
        else
            vAng.x = -90;
        end
        
        vAng.y = 0;
        vAng.z = 0;
    else
        vAng.x = math.atan2( vec.z, math.sqrt( vec.x * vec.x + vec.y * vec.y ) ) * 180 / math.pi;
        vAng.y = math.atan2( vec.y, vec.x ) * 180 / math.pi;
        vAng.z = 0;
    end
    
    vAng.x = -WrapAngle( vAng.x );
    vAng.y = WrapAngle( vAng.y );
    vAng.z = WrapAngle( vAng.z );
    
    return vAng;
end
