[![EN](https://user-images.githubusercontent.com/9499881/33184537-7be87e86-d096-11e7-89bb-f3286f752bc6.png)](https://github.com/r57zone/Half-Life-Alyx-novr/blob/master/README.md)
[![RU](https://user-images.githubusercontent.com/9499881/27683795-5b0fbac6-5cd8-11e7-929c-057833e01fb1.png)](https://github.com/r57zone/Half-Life-Alyx-novr/blob/master/README.RU.md) 
# Half-Life: Alyx без VR мод (драйвер)
Первый драйвер позволяющий пройти [Half-Life: Alyx](https://store.steampowered.com/app/546560/HalfLife_Alyx/) без VR, на клавиатуре и мыши. Этот способ позволяет полностью пройти игру и попробовать VR механики. Некоторые моменты заставят вас попотеть, но и они проходимы данным способом. Также этот метод позволяет получить весьма интересный и необычный геймплей (местами похожий на Amnesia или Penumbra), которого, к сожалению, почти не бывает в обычных играх. Я прошёл игру в VR и проходил её таким образом, и я нахожу оба опыта весьма интересными.

Драйвер можно использовать для других VR игр. Например, можно поиграть в DOOM VFR, Wolfenstein: Cyberpilot и так далее.

[![](https://user-images.githubusercontent.com/9499881/78798831-7c100200-79ca-11ea-8bb1-3b6d9cd92cc0.gif)](https://www.youtube.com/watch?v=uO7iFsKial0&list=PL7QwUKlfUhof5JI7bzpbcJub8TWF2x60Y)
[![](https://user-images.githubusercontent.com/9499881/78796937-16bb1180-79c8-11ea-819e-1a393ab699b8.gif)](https://www.youtube.com/watch?v=uO7iFsKial0&list=PL7QwUKlfUhof5JI7bzpbcJub8TWF2x60Y)
[![](https://user-images.githubusercontent.com/9499881/78798825-7aded500-79ca-11ea-9b87-565c23896ec8.gif)](https://www.youtube.com/watch?v=uO7iFsKial0&list=PL7QwUKlfUhof5JI7bzpbcJub8TWF2x60Y)
[![](https://user-images.githubusercontent.com/9499881/78796945-191d6b80-79c8-11ea-814e-06dc439a6e96.gif)](https://www.youtube.com/watch?v=uO7iFsKial0&list=PL7QwUKlfUhof5JI7bzpbcJub8TWF2x60Y)
[![](https://user-images.githubusercontent.com/9499881/78796953-1ae72f00-79c8-11ea-8ea1-e923c0b5c10b.gif)](https://www.youtube.com/watch?v=uO7iFsKial0&list=PL7QwUKlfUhof5JI7bzpbcJub8TWF2x60Y)
[![](https://user-images.githubusercontent.com/9499881/78796956-1c185c00-79c8-11ea-9155-ea3d673113f4.gif)](https://www.youtube.com/watch?v=uO7iFsKial0&list=PL7QwUKlfUhof5JI7bzpbcJub8TWF2x60Y)

## Содержание
* **[Настройка](#настройка)**
* **[Управление](#управление)**
* **[Трудности прохождения](#трудности-прохождения)**
* **[Исправление проблем](#исправление-проблем)**
* **[Мобильные и DIY VR шлемы](#мобильные-и-DIY-VR-шлемы)**
* **[Загрузка](#загрузка)**
* **[Медиа](#медиа)**
* **[Обратная связь](#обратная-связь)**

## Настройка
Процесс настройки можно увидеть в [этой инструкции с видеоматериалами](https://github.com/r57zone/Half-Life-Alyx-novr/blob/master/SETUP2.RU.md) или [детальной текстовой инструкции](https://github.com/r57zone/Half-Life-Alyx-novr/blob/master/SETUP.RU.md).

Внимательно следуйте каждому из пунктов.



О **редактировании привязки клавиш** можно прочитать [здесь](https://github.com/r57zone/Half-Life-Alyx-novr/blob/master/BINDINGS.RU.md).

## Управление
![](https://user-images.githubusercontent.com/9499881/81843920-62308480-955f-11ea-8f30-f9ee333fd0a7.PNG)

Кнопка | Описание | Обозначение в VR
------------ | ------------- | -------------
Вверх, вниз, вправо и влево | Хождение вперед, назад, влево и вправо | Тач-панель левого контроллера, с нажатиями на неё
Левая кнопка мыши или Numpad 1 | Стрельба или захват предметов правой руки | Триггер правого контроллера
Правая кнопка мыши | Режим движения левого контролера, также активирует захват на левую кнопку мыши | Триггер и движение левого контроллера
Средняя кнопка мыши | Режим выбора оружия | Нажатие на вверх тач-панели правого контроллера
Пробел | Телепорт | Нажатие на низ тач-панели правого контроллера
Правый Ctrl | Присесть | Приседание
Delete | Прицеливание | Перемещение правого контроллера и вращение
Правый Shift | Захват предметов левым контролером и подтягивание предметов (необходимо использовать команду выше, читайте настройку) | Триггер левого контроллера
Enter | Действия некоторых предметов | Меню левого контроллера
Escape | Меню игры | Кнопка захвата левого контроллера
Numpad 0 | Действия некоторых предметов | Кнопка захвата правого контроллера
Numpad "." (NUMLOCK) | Перезарядка пистолета и некоторые действия предметов | Кнопка меню правого контроллера
"\|" | Использование шприца аптечки | Вращение и перемещение в правую сторону левого контроллера
"?" | Использование рюкзака, использовать вместе с правым Shift | Перемещение левого контроллера за левый бок
" ' " | Фиксирование левого контроллера на месте (глава 5: Северная звезда) | фиксирование левого контроллера в пространстве
Backspace | Показ состояния здоровья и патронов | Вращение левого контроллера
";" | Бросание предметов (гранат, энергетических шаров и так далее). Для бросания энергетического шара в 11 главе нужно дважды нажимать кнопку | Движение левого контроллера вперед
End | Бросок энергетического шара (глава 11: Отбытие), если не работает попробуйте нажать быстро несколько раз | Движение левого контроллера
Delete | Включение и отключения режима прицеливания (отключается также при нажатии правой и средней кнопки мыши) | Перемещение контроллеров перед лицом
PageUP и PageDown | Перемещение вверх и вниз | Перемещение контроллеров и головы вверх и вниз
Numpad "-" (NUMLOCK) или “-“ | Сброс перемещения вниз и вверх | Возврат к положения до перемещения
Insert и Home | Движение контроллеров вперед и назад | Движение контроллеров вперед и назад
"{" и "}" | Перемещение левого контроллера вверх и вниз, в режиме движения левого контроллера (правая кнопка мыши) | Перемещение левого контроллера по высоте вверх и вниз
"U", "J", "H", "K" | Вращение контроллеров (использование только для отдельных моментов, необходимых в игре - глава 5: Северная звезда), после использования сбросить | Вращение обоих контроллеров
"Y" | Сброс вращения контроллеров кнопками выше | Возвращение контроллеров в состояние до вращения
"P" | Прикрытие рта (глава 7: Джефф) | Перемещение контроллера напротив головы 
"L" | Режим для разминирования лазеров (пониженная чувствительность и движения стрелками вперед и назад) | Перемещение правого контроллера
"O" | Ячейка левой руки (использовать вместе с триггером правой руки) | Перемещение правого контроллера
"N", "M" | поворот влево, поворот вправо | Нажатие на лево и право тач-панели правого контроллера

Также есть несколько альтернативных привязок кнопок в архиве драйвера. Есть профиль привязки кнопок WASD для режима зрителя (или используйте другую языковую раскладку, без буквы "S"), есть для клавиатур без Numpad и так далее.

## Трудности прохождения
• **Глава 3: Уже или будет (фиксирование колеса)**

Сначала нужно вытащить трубу из колеса. Потом немного опуститесь, с помощью кнопки "PageDown". Прокрутите колесо с помощью "RShift" и взгляда. После необходимого вращения зафиксируйте руку, с помощью кнопки " ' ". Удерживая "RShift" и " ' ", поднимите в правую руку трубу (левая кнопка мыши). Все по-прежнему удерживая все три кнопки, немного наклоните трубу вниз, с помощью кнопки "J", после чего вставляйте трубу с помощью кнопки "Insert" (движение контроллеров вперед). Весь процесс прохождения этого момента можно увидеть в [этом видео](https://youtu.be/70ok-78S2pA).



• **Глава 4: Супероружие (бросок гранаты в вентиляцию)**

Нужно поставить 2 ящика друг на друга и кинуть гранату как на [видео](https://youtu.be/RD7Hm8u2XwE). Если у вас не получается, то можно просто положить гранату поднявшись, с помощью кнопок "PageUP" и спустится, потом нажав на кнопку "Numpad -".



• **Глава 5: Северная звезда (отключение питания)**

Сначала необходимо использовать вращение ("U", "J", "H", "K"), затем сбросить ("Y"), затем поднять рычаг (левая и правая кнопка мыши + просмотр наверх или Insert и Home) и зафиксировать контроллер (" ' "). Процесс прохождения этого момента можно увидеть в [этом видео](https://youtu.be/K9PDUqsrAbQ?t=85).



• **Глава 6: Гонка вооружений (лазеры)**

Для лазеров необходимо использовать отдельный режим ("L"). Движение вверх, вниз, вправо и влево происходит мышью, а движение вперед и назад происходит кнопками (вверх, вниз). Разминирование лазеров можно увидеть в [этом видео](https://youtu.be/Xj0bpAArUaE?t=11).



• **Глава 7: Джефф (открытие бункера)**

Здесь необходимо тренировка и терпение. Сначала необходимо опустить рычаг (хватаем рычаг в режиме движения левого контроллера (левая и правая кнопка мыши) и двигаем его вниз ("}")), далее крутим 2 ячейки, сначала нужно её нужно немного подтянуть и повернуть (используем взгляд и кнопки вращения ("U", "J", "H", "K") или "Backspace"), после чего остается только опустить последний рычаг вниз. Хватам рычаг в режиме движения левой руки (левая и правая кнопка мыши), взглядом опускаем и жмем также кнопку движения контроллеров вниз ("}"). Весь процесс прохождения этого момента можно увидеть в [этом видео](https://youtu.be/Xj0bpAArUaE?t=71). Если у вас по-прежнему не получается, то можно ввести команду `ent_fire relay_debug_outro_plug_puzzle_end trigger` в консоль для открытия бункера. 



• **Глава 10: Взлом и проникновение (сражение с пауком)**

Хватаем оружие правым контроллером и направляем его в сторону паука, повыше. Далее в режиме хватаем рычаг перезарядки и двигаем его вверх и вниз, по очереди (взглядом или кнопками движения контроллеров вверх и вниз "{", "}", в режиме движения левого контроллера, левая и правая кнопка мыши). Крайне важно направить оружие повыше, чтобы попасть в финальный шар, пускаемый пауком. Сверните все уведомления SteamVR, чтобы не мешали.



• **Не хватает здоровья**

Если вы застряли и не может пройти один из тяжелых моментов, то вы можете использовать чит-код бессмертия. Для этого вам нужно запустить игру с консолью. Добавьте параметры запуска к игре `-allowdebug -vconport 29000 -vcon -console`, в ней введите `sv_cheats 1` и далее `god`, после чего вы будете бессмертны и легко пройдете сложные моменты. Не забудьте после прохождения сложного места отключить режим бессмертия введя команду `god` повторно.



**Также доступны [сохранения](https://github.com/r57zone/Half-Life-Alyx-novr/issues?q=is%3Aissue+is%3Aopen+label%3ASaves)** для пропуска сложных моментов игры.

## Исправление проблем
**Красный экран** - переключите фокус на игру "Half-Life: Alyx" через ALT + TAB, нажмите левую кнопку мыши и затем переключитесь снова на "Headset window". Также можно изменить параметр "DebugMode" на true, в файле конфигурации "default.vrsettings", если возникают какие-то проблемы с красным экраном.



**Стою в полу** - нужна калибровка комнаты SteamVR. Подробнее в [инструкциях по установке](https://github.com/r57zone/Half-Life-Alyx-novr/blob/master/SETUP.RU.md).



**Черный экран в HeadsetWindow** - неверное разрешение окна. Установите разрешение окна как у монитора. 



**Шлем не отслеживается** — это происходит, когда окно "Headset Window" находится не фокусе, нужно выбрать это окно через ALT + TAB. В настройках SteamVR можно поставить опцию не отключать дисплей 5 минут. Шлем начнет отслеживаться сразу, как только вы переключитесь в "Headset Window".



**Не работает кнопка далее при калибровке (шлем не отслеживается)** — это происходит если разрешение окна не соответствует разрешению вашего монитора.



**Не запускается в режиме VR (Headset Window)** - добавьте параметр запуска `-vr` в параметрах игры Steam или в свойствах ярлыка Windows.



**Ошибки SteamVR** - Возможно, вы неверно указали разрешение вашего монитора ("windowWidth" и "windowHeight") в конфигурационном файле "default.vrsettings". Эти параметры не могут быть меньше или больше, чтобы снизить нагрузку на систему уменьшайте "renderWidth" и "renderHeight". Также SteamVR возможно не работает на старых мониторах 5:4.



**Не работают кнопки или большая чувствительность** - запустите сначала SteamVR и только потом игру.



**Не двигаются руки** - переключитесь на "Headset Window" и нажмите левую кнопку мыши.



**Контроллеры перестают двигаться в режиме зрителя** - Не используйте клавишу "Escape". Если вы нажали ей нажмите её повторно. В раскладке WASD меню на клавишу "~".



**Использование WASD** - кнопки WASD можно использовать, играя в режиме "зрителя" или переключив языковую раскладку, где нет буквы "S" (Например, русскую, если её нет её можно добавить, а потом удалить). Подробнее [тут](https://youtu.be/JwxQ3jJ5aWA).



**Большой угол обзора** - для игры в режиме зрителя необходимо сделать [следующее](https://youtu.be/JwxQ3jJ5aWA), а для игры в режиме "VR" его можно изменить [так](https://youtu.be/wsJl_ODPSPI) или [так](https://youtu.be/8f_2GkruPdU).



**Черные углы** - можно играть в режиме зрителя полностью без них или их частично можно убрать [этим способом](https://youtu.be/wsJl_ODPSPI).



**SteamVR Home** - автоматический запуска можно отключить в настройках SteamVR.



**Игра не запускается или SteamVR** - перезагрузите компьютер или закройте Steam, SteamVR и игру в диспетчере задач, если они есть.



**Уменьшить HUD в режиме зрителя** - измените размер в настройках игры или введите команду в консоль `hlvr_spectator_hud_size 80`. Подробнее [тут](https://youtu.be/JwxQ3jJ5aWA?t=343).



Пожалуйста прочитайте [открытые](https://github.com/r57zone/Half-Life-Alyx-novr/issues) и [закрытые](https://github.com/r57zone/Half-Life-Alyx-novr/issues?q=is%3Aissue+is%3Aclosed) вопросы, а также внимательно прочтите описание. Возможно, ваша проблема уже имеет решение.

## Мобильные и DIY VR шлемы
[![](https://user-images.githubusercontent.com/9499881/80217537-e70b3b00-8650-11ea-9558-3f27a5b30cc8.gif)](https://youtu.be/4Q_YqkWfWqI)

Можно играть, стримя игру на смартфон, например, через приложение Moonlight (для Nvidia 600 серии+), [Sunshine](https://github.com/loki-47-6F-64/sunshine/releases), [OpenStream](https://open-stream.net) или Trinus. Положение головы можно передавать, используя [OpenTrack](https://github.com/opentrack/opentrack) и приложение FreePie IMU (для Android, из архива OpenTrack). Более подробную настройку можно увидеть в [этом видео](https://youtu.be/4Q_YqkWfWqI). Также можно использовать сторонние драйверы для VR шлемом из смартфона (в настройках игры нужно будет добавить кнопку приседания), для этого [переключите TrueOpenVR в режим работы только контроллеров](https://youtu.be/4Q_YqkWfWqI?t=177).


Для нового способа, где используется только SteamVR драйвер, необходимо изменить параметр `HMD` на `0`, в конфигурационном файле "...\Steam\steamapps\common\SteamVR\drivers\hlalyx\HalfLifeAlyx.ini" и установить необходимый SteamVR драйвер для шлема. 

## Загрузка
>Драйвер и необходимые утилиты<br>
**[Загрузить](https://github.com/r57zone/Half-Life-Alyx-novr/releases/)**

## Медиа
[Forbes](https://www.forbes.com/sites/davidthier/2020/04/13/heres-the-first-mod-to-play-half-life-alyx-outside-of-vr/), [PCGamer](https://www.pcgamer.com/the-first-mod-that-will-let-you-finish-half-life-alyx-without-vr-is-here/), [TheNextWeb](https://thenextweb.com/gaming/2020/04/13/you-can-now-play-half-life-alyx-without-vr-using-this-mod-but-i-wouldnt/), [GameBold](https://gamingbolt.com/half-life-alyx-sees-first-mod-to-complete-game-without-vr), [WCCFTech](https://wccftech.com/half-life-alyx-new-no-vr-mod-converts-all-gameplay-mechanics-to-keyboard-and-mouse-controls/), [Gamespot](https://www.gamespot.com/articles/how-to-play-half-life-alyx-without-a-vr-headset/1100-6475988/), [TechRadar](https://www.techradar.com/news/half-life-alyx-mod-lets-you-play-with-no-vr-headset-heres-how-to-install-it), [Kotaku](https://kotaku.com/half-life-alyx-is-now-playable-without-a-vr-headset-1842846683), [GamesRadar](https://www.gamesradar.com/half-life-alyx-no-vr-mod-complete-game/), [Gizmodo](https://es.gizmodo.com/ahora-puedes-jugar-half-life-alyx-sin-un-casco-de-real-1842848986), [IGN](https://me.ign.com/ar/half-life-alyx/140939/video/shhd-wl-mwd-kml-ytyh-tjrb-half-life-alyx-bdwn-wq-ftrdy), 
[Российская газета](https://rg.ru/2020/04/13/half-life-alyx-polnostiu-adaptirovali-dlia-igry-s-myshiu-i-klaviaturoj.html), [Регнум](https://regnum.ru/news/society/2914484.html), [MediaLeaks](https://medialeaks.ru/news/1304mmg-half-life-alyx-pc/), [3dnews](https://3dnews.ru/1008242), [Games.Mail](https://games.mail.ru/pc/news/2020-04-13/vyshel-pervyj-mod-pozvolyayushij-projti-half-life-alyx-bez-vr-shlema/), [4pda](https://4pda.ru/2020/04/13/370428/), [Stopgame](https://stopgame.ru/newsdata/42631), [Игромания](https://www.igromania.ru/news/92675/Drayver_dlya_Half-Life_Alyx_pozvolyaet_proyti_igru_bez_VR-shlema.html), [Overclockers](https://overclockers.ru/softnews/show/102757/entuziast-sdelal-dlya-half-life-alyx-mod-pozvolyajuschij-polnostju-projti-igru-s-klaviaturoj-i-myshju) и [другие](https://www.google.com/search?q=r57zone&tbm=nws).

Спасибо всем за публикации.

## Обратная связь
`r57zone[собака]gmail.com`
