[![EN](https://user-images.githubusercontent.com/9499881/33184537-7be87e86-d096-11e7-89bb-f3286f752bc6.png)](https://github.com/r57zone/Half-Life-Alyx-novr/blob/master/README.md)
[![RU](https://user-images.githubusercontent.com/9499881/27683795-5b0fbac6-5cd8-11e7-929c-057833e01fb1.png)](https://github.com/r57zone/Half-Life-Alyx-novr/blob/master/README.RU.md) 
# Half-Life: Alyx non-VR mod (driver)
First driver allows to complete [Half-Life: Alyx](https://store.steampowered.com/app/546560/HalfLife_Alyx/) without VR on keyboard and mouse. This method allows to complete the game and try out VR mechanics. Some moments will make you sweat, but they are passable in this way. Also, this method allows you to get a very interesting and unusual gameplay (sometimes similar to Amnesia or Penumbra), which unfortunately almost never happens in ordinary games. I went through the game in VR and went through it that way, and I find both experiences very interesting.

The driver can be used for other VR games, for example, you can play DOOM VFR, Wolfenstein: Cyberpilot, and so on.

[![](https://user-images.githubusercontent.com/9499881/78798831-7c100200-79ca-11ea-8bb1-3b6d9cd92cc0.gif)](https://www.youtube.com/watch?v=uO7iFsKial0&list=PL7QwUKlfUhof5JI7bzpbcJub8TWF2x60Y)
[![](https://user-images.githubusercontent.com/9499881/78796937-16bb1180-79c8-11ea-819e-1a393ab699b8.gif)](https://www.youtube.com/watch?v=uO7iFsKial0&list=PL7QwUKlfUhof5JI7bzpbcJub8TWF2x60Y)
[![](https://user-images.githubusercontent.com/9499881/78798825-7aded500-79ca-11ea-9b87-565c23896ec8.gif)](https://www.youtube.com/watch?v=uO7iFsKial0&list=PL7QwUKlfUhof5JI7bzpbcJub8TWF2x60Y)
[![](https://user-images.githubusercontent.com/9499881/78796945-191d6b80-79c8-11ea-814e-06dc439a6e96.gif)](https://www.youtube.com/watch?v=uO7iFsKial0&list=PL7QwUKlfUhof5JI7bzpbcJub8TWF2x60Y)
[![](https://user-images.githubusercontent.com/9499881/78796953-1ae72f00-79c8-11ea-8ea1-e923c0b5c10b.gif)](https://www.youtube.com/watch?v=uO7iFsKial0&list=PL7QwUKlfUhof5JI7bzpbcJub8TWF2x60Y)
[![](https://user-images.githubusercontent.com/9499881/78796956-1c185c00-79c8-11ea-9155-ea3d673113f4.gif)](https://www.youtube.com/watch?v=uO7iFsKial0&list=PL7QwUKlfUhof5JI7bzpbcJub8TWF2x60Y)

## Content
* **[Setup](#setup)**
* **[Control](#control)**
* **[Walkthrough](#walkthrough)**
* **[Walkthrough difficulties](#walkthrough-difficulties)**
* **[Troubleshooting](#troubleshooting)**
* **[Mobile and DIY VR HMD](#mobile-and-diy-vr-hmd)**
* **[Download](#download)**
* **[Media](#media)**
* **[Feedback](#feedback)**

## Setup
The setup process can be seen in [this instruction with video materials](https://github.com/r57zone/Half-Life-Alyx-novr/blob/master/SETUP2.md) or [detailed text instruction](https://github.com/r57zone/Half-Life-Alyx-novr/blob/master/SETUP.md).

Follow each item carefully.



Read about **editing key bindings** can [here](https://github.com/r57zone/Half-Life-Alyx-novr/blob/master/BINDINGS.md).

## Control
![](https://user-images.githubusercontent.com/9499881/81843920-62308480-955f-11ea-8f30-f9ee333fd0a7.PNG)

Button | description | Designation in VR
------------ | ------------- | -------------
Up, down, left and right | Going forward, backward, left and right | Touch panel of the left controller, with clicks on it
Left mouse button or Numpad 1 or ALT | Shooting or hold right-handed items | Right Controller Trigger
Right mouse button | The movement mode of the left controller also activates hold on the left mouse button | Trigger and movement of the left controller
Middle mouse button | Weapon selection mode | Pressing up the touch panel of the right controller
Space | Teleport | Pressing the bottom of the touch panel of the right controller
Right control | Crouch | Crouch
Delete | Aiming | Moving the right controller and rotating
Right Shift | Hold of items by the left controller and pulling up items (you must use the command above, read the setting) | Left Controller Trigger
Enter | Actions of some items | Left Controller Menu
Escape | Game menu | Left Controller Grip
Numpad 0 | Actions of some items | Right Controller Grip
Numpad "." | Reloading a gun and some action items | Right Controller Menu
"\|" | Using a first aid kit syringe | Rotate and move to the right side of the left controller
"?" | Using a backpack, use with the Right Shift | Moving the left controller over the left side
" ' " | Fixing left controller in place (Сhapter 5: North Star) | fixing left controller in space
Backspace | Health and ammo display | Left controller rotation
";" | Throwing items (grenades, energy balls, and so on). To throw an energy ball in chapter 11, you need to double press the button | Movement of the left controller forward
End | Throwing an energy ball (chapter 11: Departure), if it doesn’t work, try to click quickly several times | Left controller movement
Delete | Enabling and disabling aiming mode (also disabled when the right and middle mouse buttons are clicked) | Moving controllers in front of the face
PageUP and PageDown | Move up and down | Moving controllers and head up and down
Numpad "-" или "-" | Reset move down and up | Return to position before moving
"{" and "}"  | Moving the left controller up and down, in the movement mode of the left controller (right mouse button) | Move left controller up in height
Insert and Home | The movement of the controller forward and backward | The movement of the controller forward and backward
"U", "J", "H", "K" | Controllers rotation (use only for certain moments necessary in the game - Сhapter 5: North Star), reset after use | Rotation of both controllers
"Y" | Reset controllers’ rotation with the buttons above | Return controllers to state before rotation
"P" | Cover mouth (Chapter 7: Jeff) | Moving the controller in front of the head
"L" | Mode for clearing lasers (reduced sensitivity and moving on forward and backward arrows) | Move the right controller
"O" | Left hand cell (use with right hand trigger) | Moving the right controller
"N", "M" | turn left, turn right | Pressing the left and right touch panels of the right controller

There are also several alternative button bindings in the driver archive. There is a profiles key binding for WASD for spectator mode (or use a different language layout, without the character "S"), for keyboards without Numpad and so on.

## Walkthrough

[by TheMaster974](https://www.youtube.com/watch?v=SG02Pirp4a4&list=PL8tDEPB6h7LmC8VkEshjqfKOMgFkMXWSp)

## Walkthrough difficulties
• **Chapter 3: Is Or Will Be (fix the wheel)**

First you need to pull the pipe out of the wheel. Then go down a bit using the "PageDown" button. Scroll the wheel with RShift and look. After the necessary rotation, fix the hand using the " ' " button. Holding "RShift" and " ' ", raise the pipe in your right hand (left mouse button). Still holding all three buttons, slightly tilt the pipe down using the "J" button, and then insert the pipe using the "Insert" button (forward controllers move). The whole process of walkthrough this moment can be seen in [this video](https://youtu.be/70ok-78S2pA).



• **Chapter 4: Superweapon (throw grenade into the ventilation)**

You need to put 2 boxes on top of each other and throw a grenade like on [video](https://youtu.be/RD7Hm8u2XwE). If you can’t do it, you can simply put the grenade up by using the "PageUP" buttons and go down then by pressing the "Numpad -" button.



• **Chapter 5: North star (power off)**

First you need to use rotation ("U", "J", "H", "K"), then reset ("Y"), then raise the lever (left and right mouse button + look up or Insert and Home) and lock the controller (" ' "). The process of walkthrough this moment can be seen in [this video](https://youtu.be/K9PDUqsrAbQ?t=85).



• **Chapter 6: The arms Race (lasers)**

For lasers, you must use the separate mode ("L"). Move up, down, right and left with the mouse, and move forward and back with the buttons (up, down). Laser clearance can be seen in [this video](https://youtu.be/Xj0bpAArUaE?t=11).



• **Chapter 7: Jeff (opening the bunker)**

This requires training and patience. First you need to lower the lever (grab the lever in the mode of movement of the left controller (left and right mouse button) and move it down ("}")), then turn 2 cells, first you need to pull it up a little and turn it (use the view and the rotation buttons ("U", "J", "H", "K") or "Backspace"), then you only need to lower the last lever down. Grab the lever in the mode of movement of the left hand (left and right mouse buttons), look down and click the button for moving the controllers down ("}"). The entire process of walkthrough this moment can be seen in [this video](https://youtu.be/Xj0bpAArUaE?t=71). If you still can't do it, can enter a command `ent_fire relay_debug_outro_plug_puzzle_end trigger` in the console to open the hopper. 



• **Chapter 10: Breaking and entering (battle with the spider)**

We grab the weapon with the right controller and direct it towards the spider, higher. Next, in the mode, grab the reload lever and move it up and down, one at a time (by looking at or using the buttons for moving the controllers up and down "{" ,"}", in the mode for moving the left controller, the left and right mouse buttons). It is extremely important to aim the weapon higher to get into the final ball launched by the spider.



• **Not enough health**

If you are stuck and can't pass one of the hard moments, then you can use the immortality cheat code. To do this, you need to launch the game from the console. Add the launch parameters to the game `-allowdebug -vconport 29000 -vcon -console`, enter `sv_cheats 1` and then `god`, after which you will be immortal and easily pass the difficult moments. Do not forget to disable the immortality mode after walkthrough a difficult place by entering the `god` command again.



**Also** [saves are also available](https://github.com/r57zone/Half-Life-Alyx-novr/issues?q=is%3Aissue+is%3Aopen+label%3ASaves) to skip difficult moments of the game.

## Troubleshooting
**Red screen** - switch the focus to the game "Half-Life: Alyx" via ALT + TAB, press the left mouse button and then switch back to the "Headset window". You can also change the "DebugMode" parameter to true, in the "default.vrsettings" configuration file, if there are any problems with the red screen. Minimize all SteamVR notifications so they don’t interfere.



**Standing on the floor** - you need to calibrate the SteamVR room. More details in the installation instructions.



**Black screen in HeadsetWindow** - invalid window resolution. Set the window resolution as the monitor.



**Headset is not monitored** - this happens when the "Headset Window" is out of focus, you need to select this window through ALT + TAB. In the SteamVR settings, you can put the option not to turn off the display for 5 minutes. The helmet will begin to be tracked as soon as you switch to the "Headset Window".



**The next button doesn’t work during calibration (the hmd is not tracked)** - this happens if the window resolution doesn’t match the resolution of your monitor.



**Don't start in VR (Headset Window) mode** - add the `-vr` launch option in the Steam game options or in the properties of the Windows shortcut.



**SteamVR errors** - May have incorrectly specified the resolution of your monitor ("windowWidth" and "windowHeight") in the configuration file "default.vrsettings". These parameters cannot be less or more, to reduce the load on the system, reduce "renderWidth" and "renderHeight". SteamVR also may not work on older 5: 4 monitors.



**Buttons don't work or high sensitivity** - start SteamVR first and only then the game.



**Hands don't move** - switch to the "Headset Window" and click the left mouse button.



**Controllers stop moving in spectator mode** - Don't use the "Escape" key. If you clicked it, click it again. In the WASD key bindings of the menu on "~" key.



**Using WASD** - WASD buttons can be used by playing in the "spectator" mode or by switching the language layout where there is no character "S" (For example, Russian, if it is not there, you can add it and then delete it). More details [here](https://youtu.be/JwxQ3jJ5aWA).



**Large viewing angle** - To play in spectator mode need to do the [following](https://youtu.be/JwxQ3jJ5aWA), but to play in VR mode it can be changed [this way](https://youtu.be/wsJl_ODPSPI) or [this way](https://youtu.be/8f_2GkruPdU).



**Black corners** - Can play in spectator mode completely without them or they can partially be removed [this way](https://youtu.be/wsJl_ODPSPI).



**SteamVR Home** - automatic start can be disabled in the SteamVR settings.



**The game or SteamVR don't start** - restart the computer or close Steam, SteamVR and the game in the task manager, if any.



**Decrease HUD in spectator mode** - change the size in the game settings or enter the command in the console `hlvr_spectator_hud_size 80`. More details [here](https://youtu.be/JwxQ3jJ5aWA?t=343).



Please read [opened](https://github.com/r57zone/Half-Life-Alyx-novr/issues) and [closing](https://github.com/r57zone/Half-Life-Alyx-novr/issues?q=is%3Aissue+is%3Aclosed) issues and carefully read the description. Perhaps your problem already has a solution.

## Mobile and DIY VR HMD
[![](https://user-images.githubusercontent.com/9499881/80217537-e70b3b00-8650-11ea-9558-3f27a5b30cc8.gif)](https://youtu.be/4Q_YqkWfWqI)

Сan play the game on a smartphone in VR, for example, through the application Moonlight (for Nvidia 600 Series +), [Sunshine](https://github.com/loki-47-6F-64/sunshine/releases), [OpenStream](https://open-stream.net) or Trinus. Head position can be transmitted using [OpenTrack](https://github.com/opentrack/opentrack) and FreePie IMU application (for Android, from the OpenTrack archive). More detailed settings can be seen in [this video](https://youtu.be/4Q_YqkWfWqI). You can also use third-party drivers for VR with an HMD from a smartphone (in the game settings will need to add a crouch button), to do this, [switch TrueOpenVR to the controllers only mode](https://youtu.be/4Q_YqkWfWqI?t=177).


For the new method, where only the SteamVR driver is used, it is necessary to change the `HMD` parameter to `0` in the configuration file "...\Steam\steamapps\common\SteamVR\drivers\hlalyx\HalfLifeAlyx.ini" and install the necessary SteamVR driver for the HMD.

## Download
>Driver and necessary utilities<br>
**[Download](https://github.com/r57zone/Half-Life-Alyx-novr/releases)**

## Media
[Forbes](https://www.forbes.com/sites/davidthier/2020/04/13/heres-the-first-mod-to-play-half-life-alyx-outside-of-vr/), [PCGamer](https://www.pcgamer.com/the-first-mod-that-will-let-you-finish-half-life-alyx-without-vr-is-here/), [TheNextWeb](https://thenextweb.com/gaming/2020/04/13/you-can-now-play-half-life-alyx-without-vr-using-this-mod-but-i-wouldnt/), [GameBold](https://gamingbolt.com/half-life-alyx-sees-first-mod-to-complete-game-without-vr), [WCCFTech](https://wccftech.com/half-life-alyx-new-no-vr-mod-converts-all-gameplay-mechanics-to-keyboard-and-mouse-controls/), [Gamespot](https://www.gamespot.com/articles/how-to-play-half-life-alyx-without-a-vr-headset/1100-6475988/), [TechRadar](https://www.techradar.com/news/half-life-alyx-mod-lets-you-play-with-no-vr-headset-heres-how-to-install-it), [Kotaku](https://kotaku.com/half-life-alyx-is-now-playable-without-a-vr-headset-1842846683), [GamesRadar](https://www.gamesradar.com/half-life-alyx-no-vr-mod-complete-game/), [Gizmodo](https://es.gizmodo.com/ahora-puedes-jugar-half-life-alyx-sin-un-casco-de-real-1842848986), [IGN](https://me.ign.com/ar/half-life-alyx/140939/video/shhd-wl-mwd-kml-ytyh-tjrb-half-life-alyx-bdwn-wq-ftrdy), 
[Российская газета](https://rg.ru/2020/04/13/half-life-alyx-polnostiu-adaptirovali-dlia-igry-s-myshiu-i-klaviaturoj.html), [Регнум](https://regnum.ru/news/society/2914484.html), [MediaLeaks](https://medialeaks.ru/news/1304mmg-half-life-alyx-pc/), [3dnews](https://3dnews.ru/1008242), [Games.Mail](https://games.mail.ru/pc/news/2020-04-13/vyshel-pervyj-mod-pozvolyayushij-projti-half-life-alyx-bez-vr-shlema/), [4pda](https://4pda.ru/2020/04/13/370428/), [Stopgame](https://stopgame.ru/newsdata/42631), [Игромания](https://www.igromania.ru/news/92675/Drayver_dlya_Half-Life_Alyx_pozvolyaet_proyti_igru_bez_VR-shlema.html), [Overclockers](https://overclockers.ru/softnews/show/102757/entuziast-sdelal-dlya-half-life-alyx-mod-pozvolyajuschij-polnostju-projti-igru-s-klaviaturoj-i-myshju) and [others](https://www.google.com/search?q=r57zone&tbm=nws).

Thanks to everyone for posting.

## Feedback
`r57zone[at]gmail.com`
